/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Environment;
import net.argius.stew.gui.ContextMenu;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.FormedFont;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.ResultSetTableAction;
import net.argius.stew.gui.ResultSetTableHeaderCellRenderer;
import net.argius.stew.gui.ResultSetTableModel;
import net.argius.stew.gui.ResultSetTableMonitor;
import net.argius.stew.gui.ResultSetTableNullValueCellRenderer;
import net.argius.stew.gui.ResultSetTableRowHeader;
import net.argius.stew.gui.ResultSetValueComparator;
import net.argius.stew.io.Exporter;

class ResultSetTable
extends JTable {
    private static final Logger log = LoggerFactory.getLogger(ResultSetTable.class);
    private final Environment env;
    private final ResultSetTableHeaderCellRenderer headerRenderer;
    private final ResultSetTableRowHeader rowHeader;
    private int limitCount;
    private boolean[] sortedAscArray;
    private String columnAdjustMode;
    private int dragStartColumn;

    ResultSetTable(Environment environment) {
        this.env = environment;
        this.headerRenderer = new ResultSetTableHeaderCellRenderer(this.getTableHeader().getDefaultRenderer());
        this.rowHeader = new ResultSetTableRowHeader(this);
        this.limitCount = Integer.MAX_VALUE;
        this.sortedAscArray = new boolean[0];
        this.initialize();
    }

    int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int n) {
        this.limitCount = n;
    }

    String getColumnAdjustMode() {
        return this.columnAdjustMode;
    }

    void setColumnAdjustMode(String string) {
        this.columnAdjustMode = string;
    }

    private void initialize() {
        ResultSetTableAction.bindAction(this);
        this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        ContextMenu contextMenu = new ContextMenu(this);
        this.addMouseListener(contextMenu);
        jTableHeader.addMouseListener(contextMenu);
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ResultSetTable.this.onTableHeaderClicked(mouseEvent);
            }
        });
        jTableHeader.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                ResultSetTable.this.onTableHeaderClicked(mouseEvent);
            }
        });
    }

    public void setFont(Font font) {
        super.setFont(font);
        double d = this.getSizeRate(font);
        this.setRowHeight((int)(16.0 * d));
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel != null && tableColumnModel.getColumnCount() > 0) {
            this.getTableHeader().setFont(font);
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            double d2 = this.getSizeRate(this.getFont()) * 10.0;
            tableColumn.setPreferredWidth((int)(4.0 * d2));
        }
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof CellEditor) {
            CellEditor cellEditor = (CellEditor)object;
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.getModel();
            if (!resultSetTableModel.isInsertRow(this.getEditingRow())) {
                resultSetTableModel.updateCellEdited(this, cellEditor);
            }
            this.validate();
        }
        super.editingStopped(changeEvent);
    }

    public TableCellEditor getCellEditor() {
        DefaultCellEditor defaultCellEditor;
        Component component;
        TableCellEditor tableCellEditor = super.getCellEditor();
        if (tableCellEditor instanceof DefaultCellEditor && (component = (defaultCellEditor = (DefaultCellEditor)tableCellEditor).getComponent()) != null) {
            if (!component.isEnabled()) {
                log.warn("forced to enable CellEditor");
                component.setEnabled(true);
            }
            component.setFont(this.getFont());
            component.setBackground(Color.PINK);
        }
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.getValueAt(n, n2) != null) {
            return super.getCellRenderer(n, n2);
        }
        return ResultSetTableNullValueCellRenderer.INSTANCE;
    }

    private double getSizeRate(Font font) {
        return (double)font.getSize() / 1.0 / (double)FormedFont.Regular.getSize();
    }

    boolean isShowColumnNumber() {
        return this.headerRenderer.isShowNumber();
    }

    void setShowColumnNumber(boolean bl) {
        this.headerRenderer.setShowNumber(bl);
    }

    final void onTableHeaderClicked(MouseEvent mouseEvent) {
        if (this.getRowCount() == 0) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            boolean bl;
            int n = mouseEvent.getID();
            boolean bl2 = n == 501;
            boolean bl3 = bl = n == 506;
            if (bl2 || bl) {
                int n2;
                int n3;
                int n4;
                if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    this.clearSelection();
                }
                if ((n4 = this.columnAtPoint(point)) < 0 || this.getColumnCount() <= n4) {
                    return;
                }
                if (bl2) {
                    if (mouseEvent.isShiftDown()) {
                        n3 = this.dragStartColumn;
                        n2 = n4;
                    } else {
                        this.dragStartColumn = n4;
                        n3 = n4;
                        n2 = n4;
                    }
                } else if (bl) {
                    n3 = this.dragStartColumn;
                    n2 = n4;
                } else {
                    return;
                }
                this.selectColumn(n3, n2);
            }
        }
    }

    void selectColumn(int n) {
        this.selectColumn(n, n);
    }

    void selectColumn(int n, int n2) {
        if (this.getRowCount() > 0) {
            this.addColumnSelectionInterval(n, n2);
            this.addRowSelectionInterval(this.getRowCount() - 1, 0);
        }
    }

    void fitColumn0() {
    }

    final void onTableClicked(MouseEvent mouseEvent) {
    }

    void requestSort(int n) {
        int n2;
        if (n > 0 && (n2 = this.getRowCount() * (1 + this.getColumnCount() / 10)) >= 2000) {
            String string = Messages.getString("window.ResultSetTable.sort.confirm");
            int n3 = DialogMessage.confirmYesNo(this.getParent(), string);
            if (n3 != 0) {
                return;
            }
        }
        this.sort(n);
    }

    private void sort(int n) {
        int n2;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        boolean bl = this.sortedAscArray[n];
        ResultSetValueComparator resultSetValueComparator = new ResultSetValueComparator();
        for (n2 = 1; n2 < n3; ++n2) {
            Object object;
            Object object2;
            for (int i = n2; i > 0 && resultSetValueComparator.compare(object2 = this.getValueAt(i - 1, n), object = this.getValueAt(i, n)) > 0 != bl; --i) {
                this.swap(i, i - 1);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.sortedAscArray[n2] = false;
        }
        this.sortedAscArray[n] = !bl;
    }

    private void swap(int n, int n2) {
        int n3 = this.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Object object = this.getValueAt(n, i);
            this.setValueAt(this.getValueAt(n2, i), n, i);
            this.setValueAt(object, n2, i);
        }
    }

    void changeColumnWidth(double d) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = (int)((double)tableColumn.getWidth() * d);
            tableColumn.setPreferredWidth(n2);
        }
    }

    void adjustColumnWidth() {
        block8: {
            block7: {
                if (this.columnAdjustMode == null) {
                    return;
                }
                if (!this.columnAdjustMode.equalsIgnoreCase("header")) break block7;
                int n = this.getFont().getSize();
                TableColumnModel tableColumnModel = this.getColumnModel();
                int n2 = this.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    String string = String.valueOf(tableColumn.getHeaderValue());
                    int n3 = (string.length() + 1) * n;
                    tableColumn.setPreferredWidth(n3);
                }
                break block8;
            }
            if (!this.columnAdjustMode.equalsIgnoreCase("value")) break block8;
            int n = this.getRowCount();
            if (n == 0) {
                return;
            }
            int n4 = this.getFont().getSize();
            TableColumnModel tableColumnModel = this.getColumnModel();
            JTableHeader jTableHeader = this.getTableHeader();
            int n5 = this.getColumnCount();
            for (int i = 0; i < n5; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                }
                int n6 = 1;
                if (tableCellRenderer != null) {
                    n6 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)i), (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width;
                }
                for (int j = 0; j < n; ++j) {
                    TableCellRenderer tableCellRenderer2 = this.getCellRenderer(j, i);
                    Object object = this.getValueAt(j, i);
                    Component component = tableCellRenderer2.getTableCellRendererComponent(this, object, false, false, j, i);
                    n6 = Math.max(n6, component.getPreferredSize().width / 2);
                    if (!(object instanceof Date)) continue;
                    n6 *= 2;
                    if (!log.isDebugEnabled()) break;
                    log.debug("[" + i + "] size = " + n6);
                    break;
                }
                n6 = (int)((double)n6 * 1.0 / (double)n4 * 14.0);
                tableColumnModel.getColumn(i).setPreferredWidth(n6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(File file) throws IOException {
        Exporter exporter = Exporter.getExporter(file);
        try {
            int n = this.getColumnCount();
            int n2 = this.getRowCount();
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            Vector<Vector> vector = defaultTableModel.getDataVector();
            for (int i = 0; i < n2; ++i) {
                List list = (List)vector.get(i);
                exporter.addRow(list.subList(1, n).toArray());
            }
        }
        finally {
            exporter.close();
        }
    }

    int outputResultSet(ResultSet resultSet, ColumnOrder columnOrder, String string) throws SQLException {
        int n;
        Object object;
        int n2;
        int n3;
        int[] nArray;
        int n4;
        final JTableHeader jTableHeader = this.tableHeader;
        final DefaultTableModel defaultTableModel = (DefaultTableModel)this.rowHeader.getModel();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResultSetTable.this.setVisible(false);
                jTableHeader.setVisible(false);
                defaultTableModel.setRowCount(0);
            }
        });
        boolean bl = columnOrder.size() > 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (bl) {
            n4 = columnOrder.size();
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = columnOrder.getOrder(n3);
                nArray[n3] = resultSetMetaData.getColumnType(n5);
            }
        } else {
            n4 = columnOrder.size();
            n4 = resultSetMetaData.getColumnCount();
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = resultSetMetaData.getColumnType(n3 + 1);
            }
        }
        ResultSetTableMonitor resultSetTableMonitor = new ResultSetTableMonitor();
        final ResultSetTableModel resultSetTableModel = new ResultSetTableModel(n4, nArray, resultSetTableMonitor, this.rowHeader);
        for (n2 = 0; resultSet.next() && n2 < this.limitCount; ++n2) {
            object = new Vector();
            for (n = 0; n < n4; ++n) {
                int n6 = bl ? columnOrder.getOrder(n) : n + 1;
                ((Vector)object).add(resultSet.getObject(n6));
            }
            resultSetTableModel.addRow((Vector<?>)object);
        }
        object = new String[n4];
        for (n = 0; n < n4; ++n) {
            String string2 = bl ? columnOrder.getName(n) : resultSetMetaData.getColumnName(n + 1);
            object[n] = string2;
        }
        this.sortedAscArray = new boolean[n4];
        if (!this.env.getCurrentConnector().isReadOnly()) {
            resultSetTableMonitor.prepare(resultSet, string);
        }
        EventQueue.invokeLater(new Runnable((String[])object, jTableHeader){
            private final /* synthetic */ String[] val$headerValues;
            private final /* synthetic */ JTableHeader val$header;
            {
                this.val$headerValues = stringArray;
                this.val$header = jTableHeader;
            }

            public void run() {
                ResultSetTable.this.setModel(resultSetTableModel);
                int n = ResultSetTable.this.getColumnCount();
                TableColumnModel tableColumnModel = ResultSetTable.this.getColumnModel();
                for (int i = 0; i < n; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    tableColumn.setHeaderValue(this.val$headerValues[i]);
                }
                ResultSetTable.this.adjustColumnWidth();
                resultSetTableModel.addTableModelListener(ResultSetTable.this);
                this.setUpdatableSign();
                ResultSetTable.this.validate();
                this.val$header.setVisible(true);
                ResultSetTable.this.setVisible(true);
            }

            private void setUpdatableSign() {
                Container container = ResultSetTable.this.getParent();
                if (container != null && container.getParent() instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container.getParent();
                    String string = "icon.updatable." + resultSetTableModel.isUpdatable() + ".gif";
                    jScrollPane.setCorner("UPPER_LEFT_CORNER", new JLabel(new ImageIcon(this.getClass().getResource(string)), 0));
                }
            }
        });
        return n2;
    }
}

