/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.argius.stew.gui.DialogMessage;

public final class HelpInfoAction
extends AbstractAction {
    private final Container parent;

    public HelpInfoAction(Container container) {
        this.parent = container;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = Locale.getDefault().getLanguage();
            File file = new File("MANUAL_" + string);
            HelpInfoAction.showEditorPane(this.parent, file);
        }
        catch (IOException iOException) {
            DialogMessage.alert(this.parent, iOException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            DialogMessage.alert(this.parent, runtimeException.getMessage());
        }
    }

    private static void showEditorPane(Container container, File file) throws IOException {
        try {
            URL uRL = file.toURL();
            JEditorPane jEditorPane = new JEditorPane(uRL);
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            JOptionPane jOptionPane = new JOptionPane(jScrollPane, -1, -1);
            JDialog jDialog = jOptionPane.createDialog(container, "HELP");
            Point point = container.getLocation();
            point.x += 10;
            point.y += 10;
            jDialog.setLocation(point);
            Dimension dimension = container.getSize();
            dimension.width = (int)((double)dimension.width * 0.8);
            dimension.height = (int)((double)dimension.height * 0.8);
            jDialog.setSize(dimension);
            jDialog.setVisible(true);
        }
        catch (MalformedURLException malformedURLException) {
            IOException iOException = new IOException();
            iOException.initCause(malformedURLException);
            throw iOException;
        }
    }
}

