/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.ResultSetTable;
import net.argius.stew.gui.ResultSetTableModel;
import net.argius.stew.gui.ResultSetTableRowHeader;

final class ContextMenu
extends MouseAdapter {
    private static final Logger log = LoggerFactory.getLogger(ContextMenu.class);
    private final Component parent;

    ContextMenu(Component component) {
        this.parent = component;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Object object = mouseEvent.getSource();
            if (this.parent instanceof ResultSetTable) {
                this.showMenuForResultSetTable(mouseEvent);
            } else if (object instanceof JTextComponent) {
                this.showMenuForJTextComponent((JTextComponent)object, mouseEvent);
            }
        }
    }

    private void showMenuForResultSetTable(MouseEvent mouseEvent) {
        final ResultSetTable resultSetTable = (ResultSetTable)this.parent;
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)resultSetTable.getModel();
        Object object = mouseEvent.getSource();
        final int n = mouseEvent.getX();
        final int n2 = mouseEvent.getY();
        int n3 = resultSetTable.getSelectedColumn();
        int n4 = resultSetTable.getSelectedRow();
        final int n5 = resultSetTable.columnAtPoint(mouseEvent.getPoint());
        boolean bl = resultSetTableModel.isUpdatable();
        boolean bl2 = n3 >= 0;
        boolean bl3 = resultSetTableModel.isCellEditable(n4, n3);
        boolean bl4 = resultSetTableModel.isInsertRow(n4);
        boolean bl5 = ContextMenu.isClipboardEnabled();
        boolean bl6 = object instanceof ResultSetTable;
        boolean bl7 = object instanceof JTableHeader;
        boolean bl8 = object instanceof ResultSetTableRowHeader;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (bl7) {
            jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("header.sort"), 'S', new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    resultSetTable.requestSort(n5);
                }
            }));
            jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("header.selectcolumn"), 'C', new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Point point = new Point(n, n2);
                    int n3 = resultSetTable.getTableHeader().columnAtPoint(point);
                    resultSetTable.selectColumn(n3, n3);
                }
            }));
            jPopupMenu.add(new JPopupMenu.Separator());
        }
        if (bl8) {
            jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("header.selectrow"), 'R', new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n3 = resultSetTable.rowAtPoint(new Point(n, n2));
                    resultSetTable.addRowSelectionInterval(n3, n3);
                    resultSetTable.addColumnSelectionInterval(resultSetTable.getColumnCount() - 1, 0);
                }
            }));
            jPopupMenu.add(new JPopupMenu.Separator());
        }
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.copy.cell", 'C', "copy")).setEnabled(bl2);
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.copy.cell.withescape", 'E', "copy-cell-with-escape")).setEnabled(bl2);
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.paste.cell", 'P', "paste-to-selectedCells")).setEnabled(bl3);
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.null.value", 'V', "set-null-to-selectedCells")).setEnabled(bl3);
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.select.all", 'S', "selectAll"));
        jPopupMenu.add(new JPopupMenu.Separator());
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.add.newrow", 'N', "add-new-row")).setEnabled(bl3);
        jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.insert.paste", 'O', "insert-from-clipboard")).setEnabled(bl && bl5 && !bl4);
        if (bl6 || bl8) {
            jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.add.duplicatedrow", 'A', "add-duplicate-row")).setEnabled(bl3 && !bl4);
            jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.fix.insert", 'F', "insert-added-rows")).setEnabled(bl3 && bl4);
            jPopupMenu.add(ContextMenu.createJMenuItem(resultSetTable, "table.delete.row", 'D', "delete-selected-rows")).setEnabled(bl3);
        }
        jPopupMenu.show(resultSetTable, n, n2);
    }

    private void showMenuForJTextComponent(JComponent jComponent, MouseEvent mouseEvent) {
        boolean bl = ContextMenu.isClipboardEnabled();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(ContextMenu.createJMenuItem(jComponent, "text.cut", 'T', "cut"));
        jPopupMenu.add(ContextMenu.createJMenuItem(jComponent, "text.copy", 'C', "copy"));
        jPopupMenu.add(ContextMenu.createJMenuItem(jComponent, "text.paste", 'P', "paste")).setEnabled(bl);
        jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
    }

    private static JMenuItem createJMenuItem(JComponent jComponent, String string, char c, Object object) {
        final String string2 = String.valueOf(object);
        final Action action = jComponent.getActionMap().get(string2);
        if (action == null) {
            throw new IllegalStateException("action not found: " + string2);
        }
        final JComponent jComponent2 = jComponent;
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                action.actionPerformed(new ActionEvent(jComponent2, 1001, string2));
            }
        };
        KeyStroke keyStroke = string.equals("text.copy") ? ContextMenu.getKeyStroke(67, true) : (string2.equals("copy") ? ContextMenu.getKeyStroke(67, true) : (string2.equals("selectAll") ? ContextMenu.getKeyStroke(65, true) : ContextMenu.getBindedKeyStroke(jComponent.getInputMap(), object)));
        return ContextMenu.createJMenuItem(ContextMenu.getMessage(string), c, abstractAction, keyStroke);
    }

    private static JMenuItem createJMenuItem(String string, char c, Action action) {
        return ContextMenu.createJMenuItem(string, c, action, null);
    }

    private static JMenuItem createJMenuItem(String string, char c, Action action, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string, c);
        if (action != null) {
            jMenuItem.addActionListener(action);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 2 : 0);
    }

    private static KeyStroke getBindedKeyStroke(InputMap inputMap, Object object) {
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        if (keyStrokeArray == null) {
            return null;
        }
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            String string = String.valueOf(inputMap.get(keyStroke));
            if (!string.equals(object)) continue;
            return keyStroke;
        }
        return null;
    }

    private static boolean isClipboardEnabled() {
        return Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    void onMenuCopySelectedCellValueSelected(JTable jTable) {
    }

    void onMenuPasteValueToSelectedCellSelected(JTable jTable) {
    }

    void onMenuSelectAllSelected(JTable jTable) {
    }

    void onMenuResetValueSelected(JTable jTable) {
    }

    void onMenuAddNewRowSelected(JTable jTable) {
    }

    void onMenuCopyInsertRowSelected(JTable jTable) {
    }

    void onMenuInsertClipboardDataelected(JTable jTable) {
    }

    void onMenuFixInsertSelected(JTable jTable) {
    }

    void onMenuDeleteRowSelected(JTable jTable) {
    }

    void onMenuSortColumnSelected(JTable jTable, int n) {
    }

    void onMenuSelectColumnSelected(JTable jTable, int n) {
    }

    void onError(Throwable throwable) {
        log.error("", throwable);
        DialogMessage.alert(this.parent, throwable.getMessage());
    }

    private static String getMessage(String string) {
        return Messages.getString("menu.ContextMenu." + string);
    }
}

