/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.AnonymousConnector;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Connector;
import net.argius.stew.DynamicLoader;
import net.argius.stew.DynamicLoadingException;
import net.argius.stew.Environment;
import net.argius.stew.Messages;
import net.argius.stew.OutputProcessor;
import net.argius.stew.Parameter;
import net.argius.stew.StringClass;
import net.argius.stew.UsageException;

final class CommandProcessor {
    private static final Logger log = LoggerFactory.getLogger(CommandProcessor.class);
    private final Environment env;
    private final OutputProcessor op;

    CommandProcessor(Environment environment) {
        this.env = environment;
        this.op = environment.getOutputProcessor();
    }

    boolean invoke(String string) throws CommandException {
        Throwable throwable;
        Parameter parameter = new Parameter(string.replaceFirst("\\s", " "));
        String string2 = parameter.get(1);
        try {
            return this.invoke(string2, new Parameter(string));
        }
        catch (UsageException usageException) {
            throwable = new Object[]{string2, usageException.getMessage()};
            this.outputMessage("error.usage", (Object[])throwable);
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            log.error("", dynamicLoadingException);
            this.outputMessage("error.notfound", string2);
        }
        catch (CommandException commandException) {
            log.error("", commandException);
            throwable = commandException.getCause();
            String string3 = throwable == null ? commandException.getMessage() : throwable.getMessage();
            this.outputMessage("error.command", string3);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            log.error("", sQLException);
            throwable = sQLException;
            while ((sQLException2 = ((SQLException)throwable).getNextException()) != null && sQLException2 != throwable) {
                log.error("------ SQLException.getNextException ------", sQLException2);
                throwable = sQLException2;
            }
            this.outputMessage("error.sql", sQLException.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.error("", unsupportedOperationException);
            this.outputMessage("error.unsupported", unsupportedOperationException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            log.error("", runtimeException);
            this.outputMessage("error.runtime", runtimeException.getMessage());
        }
        catch (Throwable throwable2) {
            log.fatal("", throwable2);
            this.outputMessage("error.fatal", throwable2.getMessage());
        }
        try {
            boolean bl;
            Connection connection = this.env.getCurrentConnection();
            if (connection != null && (bl = connection.isClosed())) {
                log.info("connection is already closed");
                this.disconnect();
            }
        }
        catch (SQLException sQLException) {
            log.warn("", sQLException);
        }
        return true;
    }

    private boolean invoke(String string, Parameter parameter) throws SQLException {
        if (StringClass.isBlank(string)) {
            return true;
        }
        if (string.equalsIgnoreCase("exit")) {
            this.disconnect();
            this.outputMessage("exit", "Stew");
            return false;
        }
        if (string.equalsIgnoreCase("connect") || string.equalsIgnoreCase("-c")) {
            this.connect(parameter);
            return true;
        }
        Connection connection = this.env.getCurrentConnection();
        if (connection == null) {
            this.outputMessage("error.notconnect");
        } else if (string.equalsIgnoreCase("disconnect") || string.equalsIgnoreCase("-d")) {
            this.disconnect();
            this.outputMessage("disconnected");
        } else if (string.equalsIgnoreCase("commit")) {
            connection.commit();
            this.outputMessage("commited");
        } else if (string.equalsIgnoreCase("rollback")) {
            connection.rollback();
            this.outputMessage("rollbacked");
        } else {
            this.executeDynamicCommand(string, connection, parameter);
        }
        return true;
    }

    private void connect(Parameter parameter) throws SQLException {
        if (log.isInfoEnabled()) {
            log.info("connect start");
        }
        this.disconnect();
        String string = parameter.get(2);
        Connector connector = !parameter.isEmpty(3) ? AnonymousConnector.getConnector(string, parameter.get(3), parameter.get(4)) : (string.indexOf(64) >= 0 ? AnonymousConnector.getConnector(string) : this.env.getConnectorMap().getConnector(string));
        if (connector != null) {
            boolean bl;
            Connection connection = connector.getConnection();
            try {
                if (connector.isReadOnly()) {
                    connection.setReadOnly(true);
                }
            }
            catch (RuntimeException runtimeException) {
                log.warn("", runtimeException);
            }
            try {
                connection.setAutoCommit(false);
                bl = connection.getAutoCommit();
            }
            catch (RuntimeException runtimeException) {
                log.warn("", runtimeException);
                bl = false;
            }
            if (bl) {
                this.outputMessage("warn.autocommitnotavailable");
            }
            this.env.setCurrentConnection(connection);
            this.env.setCurrentConnector(connector);
            this.outputMessage("connected");
        } else {
            this.outputMessage("error.noconnector", string);
        }
        if (log.isInfoEnabled()) {
            log.info("connect end");
        }
    }

    private void disconnect() {
        if (log.isDebugEnabled()) {
            log.debug("disconnect start");
        }
        try {
            this.env.releaseConnection();
        }
        catch (SQLException sQLException) {
            this.outputMessage("warn.connectionclosedabnormally");
        }
        if (log.isDebugEnabled()) {
            log.debug("disconnect end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDynamicCommand(String string, Connection connection, Parameter parameter) {
        String[] stringArray = string.split(" ");
        String string2 = StringClass.capitalize(stringArray[0]);
        String string3 = "net.argius.stew.command." + string2;
        Command command = (Command)DynamicLoader.newInstance(string3);
        try {
            Connector connector = this.env.getCurrentConnector();
            if (connector.isReadOnly() && !command.isReadOnly()) {
                this.outputMessage("error.readonly");
                return;
            }
            command.setEnvironment(this.env);
            if (log.isInfoEnabled()) {
                log.info("command : " + command + " start");
            }
            if (log.isDebugEnabled()) {
                log.debug(parameter);
            }
            command.initialize();
            command.execute(connection, parameter);
        }
        finally {
            command.close();
        }
        if (log.isInfoEnabled()) {
            log.info("command : " + command + " end");
        }
    }

    private void outputMessage(String string) {
        this.outputMessage(string, new Object[0]);
    }

    protected void outputMessage(String string, Object object) throws CommandException {
        this.outputMessage(string, new Object[]{object});
    }

    protected void outputMessage(String string, Object[] objectArray) throws CommandException {
        String string2 = "message.command." + string;
        String string3 = objectArray.length > 0 ? MessageFormat.format(Messages.getString(string2), objectArray) : Messages.getString(string2);
        this.op.output(string3);
    }
}

