/*
 * Decompiled with CFR 0.152.
 */
package net.argius.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.argius.logging.BasicLogger;

public final class LoggingApiWrapper
extends BasicLogger {
    private final Logger logger;
    private final String targetClassName;

    public LoggingApiWrapper(String string) {
        this.logger = Logger.getLogger(string);
        this.targetClassName = string;
    }

    protected void printMessage(String string, Object object) {
        int n = LoggingApiWrapper.getLineNumber(this.targetClassName);
        String string2 = n > 0 ? ":" + n : "";
        String string3 = "(" + string + ") " + "[" + this.targetClassName + string2 + "] " + object;
        this.logger.log(Level.FINEST, string3);
    }

    protected void printStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        throwable.printStackTrace(printWriter);
        this.logger.log(Level.FINEST, stringWriter.toString());
    }
}

