/*
 * Decompiled with CFR 0.152.
 */
package net.argius.logging;

import java.lang.reflect.Constructor;
import net.argius.logging.Logger;
import net.argius.logging.NullLogger;
import net.argius.logging.StandardErrorOutputLogger;

public class LoggerFactory {
    private static final NullLogger NULL_LOGGER = new NullLogger();
    private static final boolean enable = Boolean.getBoolean("net.argius.logging");
    private static final String fqcn = System.getProperty("net.argius.logging.class");
    private static final String level = System.getProperty("net.argius.logging.level", "INFO");

    private LoggerFactory() {
    }

    public static Logger getLogger() {
        return LoggerFactory.createLogger("");
    }

    public static Logger getLogger(String string) {
        return LoggerFactory.createLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.createLogger(clazz.getName());
    }

    private static Logger createLogger(String string) {
        if (enable) {
            Logger logger;
            try {
                Class<?> clazz = Class.forName(fqcn);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                logger = (Logger)constructor.newInstance(string);
            }
            catch (Throwable throwable) {
                logger = new StandardErrorOutputLogger(string);
            }
            logger.setLevel(level);
            return logger;
        }
        return NULL_LOGGER;
    }
}

