package net.argius.stew.gui;

import java.awt.*;
import java.util.*;
import java.util.List;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * EBhE̋NB
 */
public final class WindowLauncher implements Launcher {

    private static final Logger log = LoggerFactory.getLogger(WindowLauncher.class);

    private static boolean initialized;

    private final List opList;

    private int sequentialNumber;

    /**
     * WindowLauncher̐B
     */
    public WindowLauncher() {
        if (log.isInfoEnabled()) {
            log.info("create new instance");
        }
        this.sequentialNumber = 1;
        this.opList = new LinkedList();
        if (!initialized) {
            MonospacedFontLookAndFeel.install();
            initialized = true;
        }
    }

    /* (overridden)
     * @see net.argius.stew.Launcher#launch(net.argius.stew.Environment)
     */
    public void launch(Environment env) {
        if (log.isInfoEnabled()) {
            log.info("launch");
        }
        WindowOutputProcessor op = new WindowOutputProcessor(env, this);
        opList.add(op);
        ++sequentialNumber;
    }

    /**
     * WindowOutputProcessor̍폜B
     * @param op WindowOutputProcessor
     */
    public void remove(WindowOutputProcessor op) {
        opList.remove(op);
    }

    /**
     * ׂẴEBhEB
     */
    void closeAll() {
        List list = new ArrayList(opList);
        for (int i = 0, n = list.size(); i < n; i++) {
            WindowOutputProcessor op = (WindowOutputProcessor)list.get(i);
            op.close();
        }
        list.clear();
        if (log.isInfoEnabled()) {
            log.info("exit");
        }
    }

    /**
     * AԂ̎擾B
     * 1̒ʔԁB
     * @return A
     */
    int getSequentialNumber() {
        return sequentialNumber;
    }

    /**
     * EBhE̎擾B
     * @return EBhE
     */
    int getWindowCount() {
        return opList.size();
    }

    /**
     * GUI[h̋NB
     * @param args
     */
    public static void main(String[] args) {
        Properties props = System.getProperties();
        if (!props.containsKey(PropertyKey.PROPERTIES)) {
            props.setProperty(PropertyKey.PROPERTIES, ".stew");
        }
        EventQueue.invokeLater(new Runnable() {

            /* (overridden)
             * @see java.lang.Runnable#run()
             */
            public void run() {
                try {
                    Launcher launcher = new WindowLauncher();
                    launcher.launch(new Environment());
                } catch (Throwable th) {
                    th.printStackTrace();
                    DialogMessage.alert(th.toString());
                }
            }

        });
    }

}