package net.argius.stew.gui;

import java.awt.*;
import java.beans.*;
import java.io.*;

/**
 * EBhEݒB
 * XMLEncoder/Decodergp邽߁APbeanɂȂĂB
 */
public final class WindowConfiguration implements Serializable {

    private static final long serialVersionUID = -2434363413626808526L;
    private static final String CLASS_NAME = WindowConfiguration.class.getName();
    private static final String FILE_NAME = CLASS_NAME + ".xml";

    private int width;
    private int height;
    private int x;
    private int y;
    private int separatorX;
    private Font font;
    private boolean statusBarVisibility;

    /**
     * WindowConfiguration̐B
     */
    public WindowConfiguration() {
        this.width = 640;
        this.height = 400;
        this.x = 10;
        this.y = 10;
        this.separatorX = 256;
        this.font = FormedFont.Regular;
        this.statusBarVisibility = false;
    }

    /**
     * ݒ𕜌B
     * @param window EBhE
     * @param directory ۑfBNg
     * @throws IOException o̓G[ꍇ
     */
    public static void load(Window window, File directory) throws IOException {
        File file = new File(directory, FILE_NAME);
        WindowConfiguration config;
        try {
            InputStream is = new FileInputStream(file);
            XMLDecoder decoder = new XMLDecoder(is);
            try {
                config = (WindowConfiguration)decoder.readObject();
            } finally {
                is.close();
            }
        } catch (FileNotFoundException ex) {
            config = new WindowConfiguration();
        }
        int width = config.width;
        int height = config.height;
        int x = config.x;
        int y = config.y;
        int separatorX = config.separatorX;
        Font font = config.font;
        boolean statusBarVisibility = config.statusBarVisibility;
        window.setSize(width, height);
        window.setLocation(x, y);
        window.setDividerLocation(separatorX);
        window.setFont(font);
        window.setStatusBarVisibility(statusBarVisibility);
    }

    /**
     * ݒۑB
     * @param window EBhE
     * @param directory ۑfBNg
     * @throws IOException o̓G[ꍇ
     */
    public static void save(Window window, File directory) throws IOException {
        if (!directory.isDirectory()) {
            directory.mkdirs();
            if (!directory.isDirectory()) {
                throw new IOException("failed to save configuration");
            }
        }
        WindowConfiguration config = new WindowConfiguration();
        config.width = window.getWidth();
        config.height = window.getHeight();
        config.x = window.getX();
        config.y = window.getY();
        config.separatorX = window.getDividerLocation();
        config.font = window.getFont();
        config.statusBarVisibility = window.getStatusBarVisibility();
        File file = new File(directory, FILE_NAME);
        XMLEncoder encoder = new XMLEncoder(new FileOutputStream(file));
        try {
            encoder.writeObject(config);
        } finally {
            encoder.close();
        }
    }

    /**
     * ̎擾B
     * @return 
     */
    public int getWidth() {
        return width;
    }

    /**
     * ̐ݒB
     * @param width 
     */
    public void setWidth(int width) {
        this.width = width;
    }

    /**
     * ̎擾B
     * @return 
     */
    public int getHeight() {
        return height;
    }

    /**
     * ̐ݒB
     * @param height 
     */
    public void setHeight(int height) {
        this.height = height;
    }

    /**
     * XW̎擾B
     * @return XW
     */
    public int getX() {
        return x;
    }

    /**
     * XW̐ݒB
     * @param x XW
     */
    public void setX(int x) {
        this.x = x;
    }

    /**
     * YW̎擾B
     * @return YW
     */
    public int getY() {
        return y;
    }

    /**
     * YW̐ݒB
     * @param y YW
     */
    public void setY(int y) {
        this.y = y;
    }

    /**
     * XW̎擾B
     * @return 
     */
    public int getSeparatorX() {
        return separatorX;
    }

    /**
     * XW̐ݒB
     * @param separatorX 
     */
    public void setSeparatorX(int separatorX) {
        this.separatorX = separatorX;
    }

    /**
     * tHg̎擾B
     * @return tHg
     */
    public Font getFont() {
        return font;
    }

    /**
     * tHg̐ݒB
     * @param font tHg
     */
    public void setFont(Font font) {
        this.font = font;
    }

    /**
     * Xe[^Xo[\Ԃ̎擾B
     * @return Xe[^Xo[\
     */
    public boolean isStatusBarVisibility() {
        return statusBarVisibility;
    }

    /**
     * Xe[^Xo[\Ԃ̐ݒB
     * @param statusBarVisibility Xe[^Xo[\
     */
    public void setStatusBarVisibility(boolean statusBarVisibility) {
        this.statusBarVisibility = statusBarVisibility;
    }

}