package net.argius.stew.gui;

import java.awt.*;
import java.io.*;
import java.util.*;
import java.util.List;

import javax.swing.*;

import net.argius.stew.*;

/**
 * _CAObZ[WB
 */
final class DialogMessage {

    /**
     * DialogMessage̐B
     */
    private DialogMessage() {
        // empty
    }

    /**
     * x_CAO\B
     * @param message bZ[W
     */
    public static void alert(String message) {
        JFrame frame = new JFrame();
        alert(frame, message);
        frame.dispose();
    }

    /**
     * x_CAO\B
     * @param parent eR|[lg
     * @param message bZ[W
     */
    public static void alert(Component parent, String message) {
        show(parent,
             message,
             JOptionPane.WARNING_MESSAGE,
             JOptionPane.DEFAULT_OPTION).getValue();
    }

    /**
     * ʒm_CAO\B
     * @param parent eR|[lg
     * @param message bZ[W
     */
    public static void notice(Component parent, String message) {
        show(parent,
             message,
             JOptionPane.INFORMATION_MESSAGE,
             JOptionPane.DEFAULT_OPTION).getValue();
    }

    /**
     * I"OK""CANCEL"̊mF_CAO\B
     * @param parent eR|[lg
     * @param message bZ[W
     * @return _CAȎIl
     */
    public static int confirmOkCancel(Component parent, String message) {
        JOptionPane pane = show(parent,
                                message,
                                JOptionPane.QUESTION_MESSAGE,
                                JOptionPane.OK_CANCEL_OPTION);
        Integer result = (Integer)pane.getValue();
        return result.intValue();
    }

    /**
     * I"YES""NO"̊mF_CAO\B
     * @param parent eR|[lg
     * @param message bZ[W
     * @return _CAȎIl
     */
    public static int confirmYesNo(Component parent, String message) {
        JOptionPane pane = show(parent,
                                message,
                                JOptionPane.QUESTION_MESSAGE,
                                JOptionPane.YES_NO_OPTION);
        Integer result = (Integer)pane.getValue();
        return result.intValue();
    }

    /**
     * v_EĨ_CAO\B
     * @param parent eR|[lg
     * @param message bZ[W
     * @param options I
     * @return IꂽIvV
     */
    public static Object select(Component parent,
                                String message,
                                Object[] options) {
        checkParentComponent(parent);
        JOptionPane pane = new JOptionPane(message,
                                           JOptionPane.PLAIN_MESSAGE,
                                           JOptionPane.OK_CANCEL_OPTION);
        pane.setSelectionValues(options);
        pane.setInitialSelectionValue(options[0]);
        JDialog dialog = pane.createDialog(parent, null);
        dialog.pack();
        dialog.setVisible(true);
        Object result = pane.getInputValue();
        if (result == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return result;
    }

    /**
     * _CAO\B
     * @param parent eR|[lg
     * @param message bZ[W 
     * @param messageType bZ[W
     * @param optionType IvV
     * @return JOptionPane
     */
    private static JOptionPane show(Component parent,
                                    String message,
                                    int messageType,
                                    int optionType) {
        checkParentComponent(parent);
        Object m = getMessage(message);
        JOptionPane pane = new JOptionPane(m, messageType, optionType, null);
        JDialog dialog = pane.createDialog(parent, null);
        dialog.pack();
        dialog.setVisible(true);
        return pane;
    }

    /**
     * eR|[lg`FbNB
     * @param parent eR|[lg
     */
    private static void checkParentComponent(Component parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
    }

    /**
     * bZ[WIuWFNg̎擾B
     * @param message bZ[W
     * @return bZ[WIuWFNg(Cӂ̃IuWFNg)
     */
    private static Object getMessage(String message) {
        if (StringClass.isEmpty(message)) {
            return "?";
        }
        try {
            final int limit = Toolkit.getDefaultToolkit().getScreenSize().width / 15;
            if (message.length() < limit) {
                return message;
            }
            BufferedReader reader = new BufferedReader(new StringReader(message));
            try {
                List list = new ArrayList();
                while (true) {
                    String line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    final int length = line.length();
                    if (length < limit) {
                        list.add(line);
                    } else {
                        int index = 0;
                        while (true) {
                            int p = index + limit;
                            if (p >= length) {
                                list.add(line.substring(index));
                                break;
                            } else {
                                list.add(line.substring(index, p));
                                index = p;
                            }
                        }
                    }
                }
                return list.toArray();
            } finally {
                reader.close();
            }
        } catch (IOException ex) {
            return ex;
        }
    }

}