package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * f[^x[Xe[ȕ\R}hB
 */
public final class Report extends Command {

    private static final Logger log = LoggerFactory.getLogger(Report.class);
    private static final String USAGE = getUsage("report");

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        // Es
        try {
            String p1 = parameter.get(2);
            if (p1.equals("-")) {
                reportDBInfo(conn);
            } else {
                String tableName = p1;
                String p2 = parameter.get(3);
                if (p2.equalsIgnoreCase("PK")) {
                    reportPrimaryKeyInfo(conn, tableName);
                } else if (p2.equalsIgnoreCase("INDEX")) {
                    reportIndexInfo(conn, tableName);
                } else {
                    reportTableDescription(conn, tableName);
                }
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.Command#isReadOnly()
     */
    public boolean isReadOnly() {
        return true;
    }

    /**
     * 񖼂̎擾B
     * @param key L[[h
     * @return 
     */
    private String getColumnName(String key) {
        return Messages.getString("command.report.label." + key);
    }

    /**
     * e[u`\B
     * @param conn RlNV
     * @param tableName e[u
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void reportTableDescription(Connection conn, String tableName) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report table-description of : " + tableName);
        }
        String pattern = convertPattern(tableName);
        ResultSet rs = conn.getMetaData().getColumns(null, null, pattern, null);
        try {
            ResultSetReference ref = new ResultSetReference(rs);
            ColumnOrder order = ref.getOrder();
            order.addOrder(17, getColumnName("sequence"));
            order.addOrder(4, getColumnName("columnname"));
            order.addOrder(18, getColumnName("nullable"));
            order.addOrder(6, getColumnName("type"));
            order.addOrder(7, getColumnName("size"));
            order.addOrder(2, getColumnName("schema"));
            output(ref);
            Object[] arguments = {new Integer(ref.getRecordCount())};
            outputMessage(".selected", arguments);
        } finally {
            rs.close();
        }
    }

    /**
     * vC}L[\B
     * @param conn RlNV
     * @param tableName e[u
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void reportPrimaryKeyInfo(Connection conn, String tableName) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report primary-key of : " + tableName);
        }
        String pattern = convertPattern(tableName);
        ResultSet rs = conn.getMetaData().getPrimaryKeys(null, null, pattern);
        try {
            ResultSetReference ref = new ResultSetReference(rs);
            ColumnOrder order = ref.getOrder();
            order.addOrder(1, getColumnName("catalog"));
            order.addOrder(2, getColumnName("schema"));
            order.addOrder(3, getColumnName("tablename"));
            order.addOrder(5, getColumnName("sequence"));
            order.addOrder(4, getColumnName("columnname"));
            order.addOrder(6, getColumnName("keyname"));
            output(ref);
            Object[] arguments = {new Integer(ref.getRecordCount())};
            outputMessage(".selected", arguments);
        } finally {
            rs.close();
        }
    }

    /**
     * CfbNX\B
     * @param conn RlNV
     * @param tableName e[u
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void reportIndexInfo(Connection conn, String tableName) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report index of : " + tableName);
        }
        String condition = convertPattern(tableName);
        ResultSet rs = conn.getMetaData().getIndexInfo(null,
                                                       null,
                                                       condition,
                                                       false,
                                                       false);
        try {
            ResultSetReference ref = new ResultSetReference(rs);
            ColumnOrder order = ref.getOrder();
            order.addOrder(1, getColumnName("catalog"));
            order.addOrder(2, getColumnName("schema"));
            order.addOrder(3, getColumnName("tablename"));
            order.addOrder(8, getColumnName("sequence"));
            order.addOrder(9, getColumnName("columnname"));
            order.addOrder(6, getColumnName("keyname"));
            output(ref);
            Object[] arguments = {new Integer(ref.getRecordCount())};
            outputMessage(".selected", arguments);
        } finally {
            rs.close();
        }
    }

    /**
     * f[^x[X\B
     * @param conn RlNV
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void reportDBInfo(Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report dbinfo");
        }
        DatabaseMetaData meta = conn.getMetaData();
        Object[] productName = {meta.getDatabaseProductName()};
        outputMessage("command.report.product.name", productName);
        Object[] productVersion = {meta.getDatabaseProductVersion()};
        outputMessage("command.report.product.version", productVersion);
        Object[] driverName = {meta.getDriverName()};
        outputMessage("command.report.driver.name", driverName);
        Object[] driverVersion = {meta.getDriverVersion()};
        outputMessage("command.report.driver.version", driverVersion);
        Object[] url = {meta.getURL()};
        outputMessage("command.report.url", url);
    }

}