/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.argius.stew.io.Importer;
import net.argius.stew.io.Path;
import net.argius.stew.io.SmartImporter;
import net.argius.stew.io.XmlImporter;

final class ImporterFactory {
    private ImporterFactory() {
    }

    static Importer createImporter(Path path) throws IOException {
        String string = path.getSuffix();
        if (string.equalsIgnoreCase("xml")) {
            return new XmlImporter(ImporterFactory.openFile(path));
        }
        if (string.equalsIgnoreCase("csv")) {
            return new SmartImporter(ImporterFactory.openFile(path), ",");
        }
        return new SmartImporter(ImporterFactory.openFile(path), "\t");
    }

    private static InputStream openFile(File file) throws IOException {
        return new FileInputStream(file);
    }
}

