/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.argius.stew.io.Exporter;

public final class HtmlExporter
extends Exporter {
    private PrintWriter out;

    public HtmlExporter(OutputStream outputStream, String string) {
        super(outputStream);
        this.out = new PrintWriter(outputStream);
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.print("<title>");
        this.out.print(string);
        this.out.println("</title>");
        this.out.println("</head>");
        this.out.println("<body>");
        this.out.print("<h1>");
        this.out.print(string);
        this.out.println("</h1>");
        this.out.println("<table>");
        this.out.flush();
    }

    protected void writeHeader(Object[] objectArray) throws IOException {
        this.out.println("<tr>");
        for (int i = 0; i < objectArray.length; ++i) {
            this.out.print("<th>");
            this.out.print(objectArray[i]);
            this.out.println("</th>");
        }
        this.out.println("</tr>");
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.out != null) {
                this.out.println("</table>");
                this.out.println("</body>");
                this.out.println("</html>");
                this.out.flush();
                this.out.close();
            }
        }
        finally {
            this.out = null;
            super.close();
        }
    }

    public void addRow(Object[] objectArray) {
        this.out.println("<tr>");
        for (int i = 0; i < objectArray.length; ++i) {
            this.out.print("<td>");
            this.out.print(objectArray[i]);
            this.out.println("</td>");
        }
        this.out.println("</tr>");
        this.out.flush();
    }
}

