/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import net.argius.stew.gui.Menu;

public final class MenuConfiguration
implements Serializable {
    private static final long serialVersionUID = -9070962376007964266L;
    private static final String CLASS_NAME = MenuConfiguration.class.getName();
    private static final String FILE_NAME = CLASS_NAME + ".xml";
    private String columnAdjustMode = "NONE";
    private int limitCount = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Menu menu, File file) throws IOException {
        MenuConfiguration menuConfiguration;
        File file2 = new File(file, FILE_NAME);
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            XMLDecoder xMLDecoder = new XMLDecoder(fileInputStream);
            try {
                menuConfiguration = (MenuConfiguration)xMLDecoder.readObject();
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            menuConfiguration = new MenuConfiguration();
        }
        menu.setColumnAdjustMode(menuConfiguration.columnAdjustMode);
        menu.setLimitCount(menuConfiguration.limitCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Menu menu, File file) throws IOException {
        if (!file.isDirectory()) {
            file.mkdirs();
            if (!file.isDirectory()) {
                throw new IOException("failed to save configuration");
            }
        }
        MenuConfiguration menuConfiguration = new MenuConfiguration();
        menuConfiguration.columnAdjustMode = menu.getColumnAdjustMode();
        menuConfiguration.limitCount = menu.getLimitCount();
        File file2 = new File(file, FILE_NAME);
        XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(file2));
        try {
            xMLEncoder.writeObject(menuConfiguration);
        }
        finally {
            xMLEncoder.close();
        }
    }

    public final String getColumnAdjustMode() {
        return this.columnAdjustMode;
    }

    public final void setColumnAdjustMode(String string) {
        this.columnAdjustMode = string;
    }

    public final int getLimitCount() {
        return this.limitCount;
    }

    public final void setLimitCount(int n) {
        this.limitCount = n;
    }
}

