/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.IOException;
import java.sql.Connection;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Messages;
import net.argius.stew.OutputProcessor;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;
import net.argius.stew.command.Find;
import net.argius.stew.command.Report;
import net.argius.stew.command.Select;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.ExporterOutputProcessor;
import net.argius.stew.io.Path;

public final class Export
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Export.class);
    private static final String USAGE = Export.getUsage("export");

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(USAGE);
        }
        int n = 2;
        String string = parameter.get(n++);
        String string2 = parameter.get(n);
        boolean bl = false;
        if (string2.equalsIgnoreCase("HEADER")) {
            bl = true;
            ++n;
        }
        String string3 = parameter.getAll(n);
        try {
            this.export(connection, string, bl, new Parameter(string3));
            this.output(Messages.getString("command.export.exported"));
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(Connection connection, String string, boolean bl, Parameter parameter) throws IOException {
        Command command = this.getCommand(parameter.get(1));
        Path path = Path.resolve(this.env.getCurrentDirectory(), string);
        Exporter exporter = Exporter.getExporter(path);
        try {
            if (log.isDebugEnabled()) {
                log.debug("command  : " + command);
                log.debug("exporter : " + exporter);
            }
            OutputProcessor outputProcessor = this.env.getOutputProcessor();
            ExporterOutputProcessor exporterOutputProcessor = new ExporterOutputProcessor(exporter, outputProcessor, bl);
            this.env.setOutputProcessor(exporterOutputProcessor);
            command.setEnvironment(this.env);
            command.execute(connection, parameter);
            this.env.setOutputProcessor(outputProcessor);
        }
        finally {
            exporter.close();
        }
    }

    private Command getCommand(String string) {
        Command command;
        if (string.equalsIgnoreCase("SELECT")) {
            command = new Select();
        } else if (string.equalsIgnoreCase("FIND")) {
            command = new Find();
        } else if (string.equalsIgnoreCase("REPORT")) {
            command = new Report();
        } else {
            throw new UsageException(USAGE);
        }
        return command;
    }
}

