/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.DynamicLoader;
import net.argius.stew.LocalSystem;
import net.argius.stew.OutputProcessor;
import net.argius.stew.StandardOutputProcessor;
import net.argius.stew.StringClass;

public final class Environment {
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private OutputProcessor outputProcessor;
    private ConnectorMap connectorMap;
    private Connector connector;
    private Connection conn;
    private int timeoutSeconds;
    private File systemDirectory;
    private File currentDirectory;

    public Environment() {
        this.initializeOutputProcessor();
        this.initializeQueryTimeout();
        this.connectorMap = new ConnectorMap();
        this.loadConnectorMap();
        this.systemDirectory = LocalSystem.getDirectory();
        this.currentDirectory = this.getInitialCurrentDirectory();
    }

    public Environment(Environment environment) {
        this.connectorMap = new ConnectorMap(environment.connectorMap);
        this.timeoutSeconds = environment.timeoutSeconds;
        this.systemDirectory = environment.systemDirectory;
        this.currentDirectory = environment.currentDirectory;
    }

    public void release() {
        this.outputProcessor = null;
        this.connectorMap = null;
        this.connector = null;
        this.systemDirectory = null;
        this.currentDirectory = null;
        try {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("released connection");
            }
        }
        catch (SQLException sQLException) {
            log.error("release error", sQLException);
        }
        if (log.isDebugEnabled()) {
            log.debug("released Environment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection() throws SQLException {
        block8: {
            try {
                if (this.conn != null) {
                    try {
                        this.conn.close();
                        if (log.isDebugEnabled()) {
                            log.debug("disconnected");
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        log.warn("", sQLException);
                        throw sQLException;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("not connected");
                }
            }
            finally {
                this.conn = null;
                this.connector = null;
            }
        }
    }

    private void initializeOutputProcessor() {
        OutputProcessor outputProcessor;
        if (LocalSystem.containsKey("net.argius.stew.OutputProcessor.class")) {
            String string = LocalSystem.getProperty("net.argius.stew.OutputProcessor.class");
            outputProcessor = (OutputProcessor)DynamicLoader.newInstance(string);
        } else {
            outputProcessor = new StandardOutputProcessor();
        }
        this.outputProcessor = outputProcessor;
        if (log.isDebugEnabled()) {
            log.debug("OutputProcessor : " + this.outputProcessor);
        }
    }

    private File getInitialCurrentDirectory() {
        File file;
        if (LocalSystem.containsKey("net.argius.stew.directory") && (file = new File(LocalSystem.getProperty("net.argius.stew.directory"))).isDirectory()) {
            return file;
        }
        return new File(".");
    }

    private void initializeQueryTimeout() {
        String string = LocalSystem.getProperty("net.argius.stew.query.timeout");
        int n = -1;
        if (!StringClass.isBlank(string)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.timeoutSeconds = n;
        if (log.isDebugEnabled()) {
            log.debug("timeout(String) : " + string);
            log.debug("timeout(int)    : " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConnectorMap() {
        ConnectorMap connectorMap;
        Object object;
        File file = new File(LocalSystem.getDirectory(), "connector.properties");
        try {
            object = new FileInputStream(file);
            try {
                connectorMap = ConnectorConfiguration.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            connectorMap = new ConnectorMap();
        }
        object = this.connectorMap;
        synchronized (object) {
            if (this.connectorMap.size() > 0) {
                this.connectorMap.clear();
            }
            this.connectorMap.putAll(connectorMap);
        }
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public void setOutputProcessor(OutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
    }

    public ConnectorMap getConnectorMap() {
        return this.connectorMap;
    }

    public Connector getCurrentConnector() {
        return this.connector;
    }

    protected void setCurrentConnector(Connector connector) {
        this.connector = connector;
    }

    public Connection getCurrentConnection() {
        return this.conn;
    }

    protected void setCurrentConnection(Connection connection) {
        this.conn = connection;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public File getSystemDirectory() {
        return this.systemDirectory;
    }
}

