/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.argius.stew.DynamicLoadingException;
import net.argius.stew.StringClass;

public final class DynamicLoader {
    private static final String CLASSFILE_SUFFIX = ".class";
    private static final int CLASSFILE_SUFFIX_LENGTH = ".class".length();

    private DynamicLoader() {
    }

    public static Class loadClass(String string) throws DynamicLoadingException {
        return DynamicLoader.loadClass(string, ClassLoader.getSystemClassLoader());
    }

    public static Class loadClass(String string, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            return classLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("class loading error", throwable);
        }
    }

    public static Object newInstance(String string) throws DynamicLoadingException {
        ClassLoader classLoader = DynamicLoader.class.getClassLoader();
        return DynamicLoader.newInstance(string, classLoader);
    }

    public static Object newInstance(String string, URL[] uRLArray) throws DynamicLoadingException {
        return DynamicLoader.newInstance(string, DynamicLoader.getURLClassLoader(uRLArray));
    }

    public static Object newInstance(String string, ClassLoader classLoader) throws DynamicLoadingException {
        return DynamicLoader.newInstance(DynamicLoader.loadClass(string, classLoader));
    }

    public static Object newInstance(Class clazz) throws DynamicLoadingException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new DynamicLoadingException("load error : " + clazz, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DynamicLoadingException("load error : " + clazz, illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getClasses(URL uRL) {
        Class[] classArray;
        String string = uRL.getPath();
        File file = new File(string);
        URLClassLoader uRLClassLoader = DynamicLoader.getURLClassLoader(new URL[]{uRL});
        if (file.isDirectory()) {
            ArrayList arrayList = new ArrayList();
            DynamicLoader.findClasses(arrayList, string.length() + 1, file, uRLClassLoader);
            return arrayList.toArray(new Class[arrayList.size()]);
        }
        ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
        try {
            classArray = DynamicLoader.getClasses(zipInputStream, uRLClassLoader);
        }
        catch (Throwable throwable) {
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new DynamicLoadingException("", iOException);
            }
        }
        zipInputStream.close();
        return classArray;
    }

    public static Class[] getClasses(URL[] uRLArray) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            arrayList.addAll(Arrays.asList(DynamicLoader.getClasses(uRL)));
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static URLClassLoader getURLClassLoader(URL[] uRLArray) {
        final URL[] uRLArray2 = uRLArray;
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(uRLArray2, ClassLoader.getSystemClassLoader());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void findClasses(List list, int n, File file, URLClassLoader uRLClassLoader) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray.length == 0) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                DynamicLoader.findClasses(list, n, file2, uRLClassLoader);
            }
            return;
        } else {
            try {
                String string = file.getAbsolutePath().substring(n);
                String string2 = DynamicLoader.toClassString(string);
                if (string2 == null) return;
                list.add(DynamicLoader.loadClass(string2, uRLClassLoader));
                return;
            }
            catch (DynamicLoadingException dynamicLoadingException) {
                // empty catch block
            }
        }
    }

    private static Class[] getClasses(ZipInputStream zipInputStream, ClassLoader classLoader) throws IOException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (zipInputStream.available() != 0) {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null) {
                zipInputStream.closeEntry();
                continue;
            }
            try {
                String string = DynamicLoader.toClassString(zipEntry.getName());
                if (string == null) continue;
                arrayList.add(DynamicLoader.loadClass(string, classLoader));
            }
            catch (DynamicLoadingException dynamicLoadingException) {}
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static String toClassString(String string) {
        if (string != null && string.endsWith(CLASSFILE_SUFFIX)) {
            int n = string.length() - CLASSFILE_SUFFIX_LENGTH;
            String string2 = string;
            string2 = string2.replace('/', '.');
            string2 = string2.replace('\\', '.');
            return string2.substring(0, n);
        }
        return null;
    }

    public static Class[] getExtendedClasses(Class clazz, URL[] uRLArray) {
        Class[] classArray = DynamicLoader.getClasses(uRLArray);
        ArrayList<Class> arrayList = new ArrayList<Class>();
        block0: for (int i = 0; i < classArray.length; ++i) {
            for (Class clazz2 = classArray[i]; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (!DynamicLoader.isSame(clazz2, clazz)) continue;
                arrayList.add(classArray[i]);
                continue block0;
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public static Class[] getImplementedClasses(Class clazz, URL[] uRLArray) {
        Class[] classArray = DynamicLoader.getClasses(uRLArray);
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < classArray.length; ++i) {
            for (Class clazz2 = classArray[i]; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (!DynamicLoader.isImplemented(clazz2, clazz)) continue;
                arrayList.add(classArray[i]);
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static boolean isImplemented(Class clazz, Class clazz2) {
        if (!clazz2.isInterface()) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!DynamicLoader.isSame(classArray[i], clazz2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSame(Class clazz, Class clazz2) {
        return StringClass.equals(clazz, clazz2);
    }
}

