package net.argius.stew.io;

import java.io.*;

/**
 * C|[g̊NXB
 * 
 * (getImporter)ꍇA
 * t@C`͈ȉ̂悤Ɋgqɂ莩IɑIB
 * <ul>
 * <li>gq"csv"̏ꍇCSV`Ƃăt@CǂݍށB
 * <li>LȊȌꍇ̓^u؂`Ƃăt@CǂݍށB
 * </ul>
 */
public abstract class Importer {

    protected InputStream is;
    protected boolean wasReadHeader;

    /**
     * Importer̐B
     * @param is ̓Xg[
     */
    protected Importer(InputStream is) {
        this.is = is;
        this.wasReadHeader = false;
    }

    /**
     * wb_擾B
     * @return wb_
     * @throws IOException o̓G[ꍇ 
     */
    public Object[] getHeader() throws IOException {
        Object[] header = readHeader();
        wasReadHeader = true;
        return header;
    }

    /**
     * wb_ǂݍށB
     * @return wb_
     * @throws IOException o̓G[ꍇ 
     */
    protected Object[] readHeader() throws IOException {
        return nextRow();
    }

    /**
     * IB
     * @throws IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        if (is != null) {
            try {
                is.close();
            } finally {
                is = null;
            }
        }
    }

    /**
     * ImporterIɑIĎ擾B
     * @see Importer
     * @param file t@C
     * @return Importer
     * @throws IOException o̓G[ꍇ
     */
    public static Importer getImporter(File file) throws IOException {
        return ImporterFactory.createImporter(new Path(file));
    }

    /**
     * ImporterIɑIĎ擾B
     * @see Importer
     * @param fileName t@C
     * @return Importer
     * @throws IOException o̓G[ꍇ 
     */
    public static Importer getImporter(String fileName) throws IOException {
        return ImporterFactory.createImporter(new Path(fileName));
    }

    /**
     * ̍sԂB
     * @return s ̍sȂꍇ͋z([̔z)
     * @throws IOException o̓G[ꍇ
     */
    public abstract Object[] nextRow() throws IOException;

}