package net.argius.logging;

import java.text.*;
import java.util.*;

/**
 * WG[o͂o͐ƂLoggerB
 */
final class StandardErrorOutputLogger extends BasicLogger {

    private final String targetClassName;

    /**
     * StandardErrorOutputLogger̐B
     * @param targetClassName ΏۃNX
     */
    public StandardErrorOutputLogger(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    /* (overridden)
     * @see net.argius.logging.BasicLogger#printMessage(java.lang.String, java.lang.Object)
     */
    protected void printMessage(String levelString, Object object) {
        System.err.print(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(new Date()));
        System.err.print(" (" + levelString + ")");
        System.err.print(" [" + targetClassName + "] ");
        System.err.println(object);
    }

    /* (overridden)
     * @see net.argius.logging.BasicLogger#printStackTrace(java.lang.Throwable)
     */
    protected void printStackTrace(Throwable th) {
        th.printStackTrace(System.err);
    }

}