package net.argius.logging;

import java.lang.reflect.*;

/**
 * Logger̃t@NgB
 */
public class LoggerFactory {

    private static final String PROPERTYKEY_ENABLE = "net.argius.logging";
    private static final String PROPERTYKEY_CLASS = "net.argius.logging.class";
    private static final String PROPERTYKEY_LEVEL = "net.argius.logging.level";

    /**
     * LoggerFactory̐B
     */
    private LoggerFactory() {
        // no instance
    }

    /**
     * Logger̎擾B
     * @return Logger
     */
    public static Logger getLogger() {
        return createLogger("");
    }

    /**
     * Logger̎擾B
     * @param targetName Ώۖ
     * @return Logger
     */
    public static Logger getLogger(String targetName) {
        return createLogger(targetName);
    }

    /**
     * Logger̎擾B
     * @param targetClass ΏۃNX
     * @return Logger
     */
    public static Logger getLogger(Class targetClass) {
        return createLogger(targetClass.getName());
    }

    /**
     * Logger̐B
     * @param targetName Ώۖ
     * @return Logger
     */
    private static Logger createLogger(String targetName) {
        Logger log;
        if (Boolean.getBoolean(PROPERTYKEY_ENABLE)) {
            String fqcn = System.getProperty(PROPERTYKEY_CLASS);
            try {
                Class loggerClass = Class.forName(fqcn);
                Constructor ctor = loggerClass.getConstructor(new Class[]{String.class});
                log = (Logger)ctor.newInstance(new Object[]{targetName});
            } catch (Throwable th) {
                log = new StandardErrorOutputLogger(targetName);
                log.warn("", th);
            }
        } else {
            log = new NullLogger();
        }
        log.setLevel(System.getProperty(PROPERTYKEY_LEVEL));
        return log;
    }

}