/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.LocalSystem;
import net.argius.stew.StringClass;
import net.argius.stew.gui.NamedValue;

final class ResultSetTableMonitor {
    private static final Logger log = LoggerFactory.getLogger(ResultSetTableMonitor.class);
    private static final String PTN1 = "^.*\\s*SELECT\\s*.+\\s*FROM\\s*(.+)$";
    private static final String PROPERTY_TIMEOUT = ResultSetTableMonitor.class.getName() + ".timeout";
    private static final int TIMEOUT_DEFAULT = 10;
    private final int timeout;
    private boolean isUpdatable = false;
    private String tableName = "";
    private String[] primaryKeys = new String[0];
    private Connection conn;

    ResultSetTableMonitor() {
        int n;
        try {
            String string = LocalSystem.getProperty(PROPERTY_TIMEOUT);
            n = StringClass.isBlank(string) ? 10 : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 10;
        }
        this.timeout = n;
    }

    synchronized void prepare(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            return;
        }
        Statement statement = resultSet.getStatement();
        if (statement == null) {
            return;
        }
        Connection connection = statement.getConnection();
        if (connection == null) {
            return;
        }
        if (connection.isReadOnly()) {
            return;
        }
        String string2 = ResultSetTableMonitor.findTableName(string);
        if (StringClass.isEmpty(string2)) {
            return;
        }
        String[] stringArray = ResultSetTableMonitor.findPrimaryKeys(connection, string2);
        if (stringArray.length < 1) {
            return;
        }
        if (ResultSetTableMonitor.findUnion(string)) {
            return;
        }
        this.tableName = string2;
        this.primaryKeys = stringArray;
        this.conn = connection;
        this.isUpdatable = true;
    }

    private static String findTableName(String string) {
        Pattern pattern;
        Matcher matcher;
        if (string != null && (matcher = (pattern = Pattern.compile(PTN1, 2)).matcher(string)).find()) {
            String string2;
            String string3 = matcher.group(1);
            String[] stringArray = string3.split("\\s");
            boolean bl = false;
            for (int i = 0; i < 2 && i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.indexOf(44) < 0) continue;
                bl = true;
            }
            if (!bl && (string2 = stringArray[0]).matches("[A-Za-z0-9_\\.]+")) {
                return string2;
            }
        }
        return "";
    }

    private static String[] findPrimaryKeys(Connection connection, String string) throws SQLException {
        String[] stringArray;
        String string2;
        String string3;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string4 = databaseMetaData.getUserName();
        if (string4 == null) {
            string4 = "";
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string3 = string4.toLowerCase();
            string2 = string.toLowerCase();
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            string3 = string4.toUpperCase();
            string2 = string.toUpperCase();
        } else {
            string3 = string4;
            string2 = string;
        }
        if (string2.indexOf(46) >= 0) {
            stringArray = string2.split("\\.");
            string3 = stringArray[0];
            string2 = stringArray[1];
        }
        if ((stringArray = ResultSetTableMonitor.getPrimaryKeys(databaseMetaData, string3, string2)).length > 0) {
            return stringArray;
        }
        return ResultSetTableMonitor.getPrimaryKeys(databaseMetaData, null, string2);
    }

    private static boolean findUnion(String string) {
        String string2 = string;
        if (string2.indexOf("'") >= 0) {
            if (string2.indexOf("\\'") >= 0) {
                string2 = string2.replaceAll("\\'", "");
            }
            string2 = string2.replaceAll("'[^']+'", "''");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase("UNION")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getPrimaryKeys(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, string, string2);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashSet<String> hashSet = new HashSet<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(4));
                hashSet.add(resultSet.getString(2));
            }
            if (hashSet.size() < 2) {
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return stringArray;
            }
        }
        finally {
            resultSet.close();
        }
        return new String[0];
    }

    private static String quoteIfNeeds(String string) {
        if (string != null && string.indexOf(45) >= 0) {
            return '\"' + string + '\"';
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Map map, NamedValue namedValue) throws SQLException {
        this.checkConnection();
        String string = namedValue.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" SET ");
        stringBuffer.append(ResultSetTableMonitor.quoteIfNeeds(string));
        stringBuffer.append("=? WHERE ");
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(ResultSetTableMonitor.quoteIfNeeds(this.primaryKeys[i]));
            stringBuffer.append("=?");
        }
        String string2 = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string2);
            log.debug("parameter : " + namedValue);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
        try {
            int n;
            preparedStatement.setQueryTimeout(this.timeout);
            int n2 = 1;
            Object object = namedValue.getValue();
            if (object == null) {
                preparedStatement.setNull(n2++, 1);
            } else {
                preparedStatement.setObject(n2++, object);
            }
            for (n = 0; n < this.primaryKeys.length; ++n) {
                preparedStatement.setObject(n2++, map.get(this.primaryKeys[n]));
            }
            n = preparedStatement.executeUpdate();
            this.checkUpdateCount(n);
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Map map, NamedValue[] namedValueArray) throws SQLException {
        int n;
        this.checkConnection();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" SET ");
        int n2 = namedValueArray.length;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            NamedValue namedValue = namedValueArray[n];
            stringBuffer.append(ResultSetTableMonitor.quoteIfNeeds(namedValue.getName()));
            stringBuffer.append("=?");
            arrayList.add(namedValue.getValue());
        }
        stringBuffer.append(" WHERE ");
        for (n = 0; n < this.primaryKeys.length; ++n) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(ResultSetTableMonitor.quoteIfNeeds(this.primaryKeys[n]));
            stringBuffer.append("=?");
        }
        String string = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string);
            log.debug("parameter : " + arrayList);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        try {
            int n3;
            preparedStatement.setQueryTimeout(this.timeout);
            int n4 = 1;
            int n5 = arrayList.size();
            for (n3 = 0; n3 < n5; ++n3) {
                Object e = arrayList.get(n3);
                if (e == null) {
                    preparedStatement.setNull(n4++, 1);
                    continue;
                }
                preparedStatement.setObject(n4++, e);
            }
            for (n3 = 0; n3 < this.primaryKeys.length; ++n3) {
                preparedStatement.setObject(n4++, map.get(this.primaryKeys[n3]));
            }
            n3 = preparedStatement.executeUpdate();
            this.checkUpdateCount(n3);
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(Map map) throws SQLException {
        Object object;
        Object object2;
        this.checkConnection();
        ArrayList arrayList = new ArrayList();
        Map.Entry[] entryArray = map.entrySet().iterator();
        while (entryArray.hasNext()) {
            Map.Entry entry = entryArray.next();
            object2 = entry.getValue();
            if (object2 == null) continue;
            arrayList.add(entry);
        }
        entryArray = arrayList.toArray(new Map.Entry[arrayList.size()]);
        int n = entryArray.length;
        object2 = new StringBuffer();
        ((StringBuffer)object2).append("INSERT INTO ");
        ((StringBuffer)object2).append(this.tableName);
        ((StringBuffer)object2).append(" (");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((StringBuffer)object2).append(',');
                stringBuffer.append(',');
            }
            object = (String)entryArray[i].getKey();
            ((StringBuffer)object2).append(ResultSetTableMonitor.quoteIfNeeds((String)object));
            stringBuffer.append('?');
        }
        ((StringBuffer)object2).append(") VALUES (");
        ((StringBuffer)object2).append(stringBuffer);
        ((StringBuffer)object2).append(')');
        String string = ((StringBuffer)object2).toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string);
            log.debug("parameter : " + map);
        }
        object = this.conn.prepareStatement(string);
        try {
            int n2;
            object.setQueryTimeout(this.timeout);
            for (n2 = 0; n2 < n; ++n2) {
                object.setObject(n2 + 1, entryArray[n2].getValue());
            }
            n2 = object.executeUpdate();
            this.checkUpdateCount(n2);
        }
        finally {
            object.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Map map) throws SQLException {
        this.checkConnection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(ResultSetTableMonitor.quoteIfNeeds(this.primaryKeys[i]));
            stringBuffer.append("=?");
        }
        String string = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        try {
            int n;
            preparedStatement.setQueryTimeout(this.timeout);
            for (n = 0; n < this.primaryKeys.length; ++n) {
                preparedStatement.setObject(n + 1, map.get(this.primaryKeys[n]));
            }
            n = preparedStatement.executeUpdate();
            this.checkUpdateCount(n);
        }
        finally {
            preparedStatement.close();
        }
    }

    private void checkConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw new SQLException("connection is already closed");
        }
    }

    private void checkUpdateCount(int n) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("updated count = " + n);
        }
        if (n != 1) {
            throw new SQLException("incorrect count : " + n);
        }
    }

    boolean isUpdatable() {
        return this.isUpdatable;
    }

    String getTableName() {
        return this.tableName;
    }

    String[] getPrimaryKeys() {
        return (String[])this.primaryKeys.clone();
    }
}

