/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.CellEditor;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.NamedValue;
import net.argius.stew.gui.ResultSetTable;
import net.argius.stew.gui.ResultSetTableMonitor;
import net.argius.stew.gui.ResultSetValueComparator;

class ResultSetTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 6814361740331839406L;
    private static final String INSERT_MARK = "*";
    private static final Comparator CMP = new ResultSetValueComparator();
    private static final Logger log = LoggerFactory.getLogger(ResultSetTableModel.class);
    private final int[] types;
    private final ResultSetTableMonitor monitor;

    ResultSetTableModel(int n, int[] nArray, ResultSetTableMonitor resultSetTableMonitor) {
        super(0, n + 1);
        this.types = new int[n + 1];
        this.types[0] = 4;
        System.arraycopy(nArray, 0, this.types, 1, n);
        this.monitor = resultSetTableMonitor;
    }

    public Class getColumnClass(int n) {
        switch (this.types[n]) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 < 1) {
            return false;
        }
        if (!this.isInsertRow(n) && !this.monitor.isUpdatable()) {
            return false;
        }
        return super.isCellEditable(n, n2);
    }

    boolean isUpdatable() {
        return this.monitor.isUpdatable();
    }

    void addRowAsInsert(Object[] objectArray) {
        objectArray[0] = INSERT_MARK;
        this.addRow(objectArray);
    }

    boolean isInsertRow(int n) {
        if (n < 0 || this.getRowCount() <= n) {
            return false;
        }
        return String.valueOf(this.getValueAt(n, 0)).equals(INSERT_MARK);
    }

    void updateCellEdited(ResultSetTable resultSetTable, CellEditor cellEditor) {
        try {
            int n = resultSetTable.getEditingColumn();
            int n2 = resultSetTable.getEditingRow();
            if (resultSetTable.getCellEditor(n2, n) == cellEditor) {
                this.updateValueChanged(resultSetTable, n2, n, this.getValueAt(n2, n), cellEditor.getCellEditorValue());
                return;
            }
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
        cellEditor.cancelCellEditing();
    }

    void updateValueChanged(JTable jTable, int n, int n2, Object object, Object object2) throws SQLException {
        if (CMP.compare(object, object2) == 0) {
            if (log.isDebugEnabled()) {
                log.debug("skip to update.");
            }
        } else if (!this.isInsertRow(n)) {
            String[] stringArray = this.getKeys(jTable);
            Map map = this.getRowData(stringArray, n);
            String string = stringArray[n2 - 1];
            NamedValue namedValue = new NamedValue(string, object2);
            this.monitor.update(map, namedValue);
        }
    }

    void updateRowInserted(JTable jTable) throws SQLException {
        int n = jTable.getSelectedRow();
        this.updateRowInserted(jTable, n);
    }

    void updateRowInserted(JTable jTable, int n) throws SQLException {
        String[] stringArray = this.getKeys(jTable);
        Map map = this.getRowData(stringArray, n);
        this.monitor.insert(map);
        this.setValueAt("", n, 0);
    }

    void updateRowDeleted(JTable jTable) throws SQLException {
        int[] nArray = jTable.getSelectedRows();
        this.updateRowDeleted(jTable, nArray);
    }

    void updateRowDeleted(JTable jTable, int[] nArray) throws SQLException {
        String[] stringArray = this.getKeys(jTable);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Map map = this.getRowData(stringArray, n);
            this.monitor.delete(map);
        }
    }

    private String[] getKeys(JTable jTable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getColumnCount();
        for (int i = 1; i < n; ++i) {
            Object object = tableColumnModel.getColumn(i).getHeaderValue();
            arrayList.add(object.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Map getRowData(String[] stringArray, int n) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            Object object = this.getValueAt(n, i + 1);
            linkedHashMap.put(string, object);
        }
        return linkedHashMap;
    }

    private void onError(Throwable throwable) {
        log.error("", throwable);
        DialogMessage.alert(throwable.getMessage());
    }
}

