/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import net.argius.stew.CommandException;
import net.argius.stew.CommandProcessor;
import net.argius.stew.Environment;
import net.argius.stew.Messages;
import net.argius.stew.Parameter;

public abstract class Command {
    private static final String SELECT = "SELECT";
    private static final int SELECT_LENGTH = "SELECT".length();
    protected Environment env;

    protected Command() {
    }

    public void initialize() throws CommandException {
    }

    public abstract void execute(Connection var1, Parameter var2) throws CommandException;

    public void close() throws CommandException {
        this.env = null;
    }

    public static boolean invoke(Environment environment, String string) throws CommandException {
        CommandProcessor commandProcessor = new CommandProcessor(environment);
        return commandProcessor.invoke(string);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected void setTimeout(Statement statement) throws SQLException {
        int n = this.env.getTimeoutSeconds();
        if (n >= 0) {
            statement.setQueryTimeout(n);
        }
    }

    public final void setEnvironment(Environment environment) {
        this.env = environment;
    }

    protected final void output(Object object) throws CommandException {
        this.env.getOutputProcessor().output(object);
    }

    protected final void outputMessage(String string, Object object) throws CommandException {
        this.outputMessage(string, new Object[]{object});
    }

    protected final void outputMessage(String string, Object[] objectArray) throws CommandException {
        String string2 = objectArray.length > 0 ? MessageFormat.format(Messages.getString(string), objectArray) : Messages.getString(string);
        this.output(string2);
    }

    protected final String convertPattern(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.env.getCurrentConnection().getMetaData();
        String string2 = databaseMetaData.storesLowerCaseIdentifiers() ? string.toLowerCase() : (databaseMetaData.storesUpperCaseIdentifiers() ? string.toUpperCase() : string);
        return string2.replace('*', '%').replace('?', '_');
    }

    protected static String getUsage(String string) {
        return Messages.getString("command." + string + ".usage");
    }

    protected static boolean isSelect(String string) {
        if (string != null && string.length() >= SELECT_LENGTH) {
            return SELECT.equalsIgnoreCase(string.substring(0, SELECT_LENGTH));
        }
        return false;
    }
}

