package net.argius.stew;

import java.sql.*;
import java.text.*;

/**
 * R}h̊B
 */
public abstract class Command {

    // for "isSelect"
    private static final String SELECT = "SELECT";
    private static final int SELECT_LENGTH = SELECT.length();

    protected Environment env;

    /**
     * Command̐B
     */
    protected Command() {
        // empty
    }

    /**
     * B
     * @throws CommandException R}hO
     */
    public void initialize() throws CommandException {
        // empty
    }

    /**
     * R}hsB
     * @param conn RlNV
     * @param parameter p[^
     * @throws CommandException R}hO
     */
    public abstract void execute(Connection conn, Parameter parameter) throws CommandException;

    /**
     * R}hB
     * š㏈ȂǂsB
     * @throws CommandException R}hO
     */
    public void close() throws CommandException {
        env = null;
    }

    /**
     * R}hNB
     * @param env s
     * @param parameterString p[^
     * @return 𑱍sꍇ <code>true</code>Afꍇ <code>false</code> 
     * @throws CommandException R}hO
     */
    public static boolean invoke(Environment env, String parameterString) throws CommandException {
        CommandProcessor processor = new CommandProcessor(env);
        return processor.invoke(parameterString);
    }

    /**
     * R}hǎpǂ𒲍B
     * ǎp̃R}h́Ã\bhI[o[ChB
     * @return R}hǎpȂ<code>true</code>A
     *         łȂ<code>false</code> 
     */
    public boolean isReadOnly() {
        return false;
    }

    /**
     * ^CAEg̐ݒB
     * ݒl<code>0</code>ȏ̏ꍇ̂ݐݒ肳B
     * @param stmt Statement
     * @throws SQLException
     * @see Statement#setQueryTimeout(int)
     */
    protected void setTimeout(Statement stmt) throws SQLException {
        int timeoutSeconds = env.getTimeoutSeconds();
        if (timeoutSeconds >= 0) {
            stmt.setQueryTimeout(timeoutSeconds);
        }
    }

    /**
     * Environment̐ݒB
     * @param environment Environment
     */
    public final void setEnvironment(Environment environment) {
        this.env = environment;
    }

    /**
     * Cӂ̃IuWFNgo͂B
     * @param object IuWFNg
     * @throws CommandException R}hO
     */
    protected final void output(Object object) throws CommandException {
        env.getOutputProcessor().output(object);
    }

    /**
     * bZ[Wo͂B
     * @param id bZ[WID
     * @param argument MessageFormatɓn
     * @throws CommandException R}hO
     */
    protected final void outputMessage(String id, Object argument) throws CommandException {
        outputMessage(id, new Object[]{argument});
    }

    /**
     * bZ[Wo͂B
     * @param id bZ[WID
     * @param arguments MessageFormatɓn
     * @throws CommandException R}hO
     */
    protected final void outputMessage(String id, Object[] arguments) throws CommandException {
        String message;
        if (arguments.length > 0) {
            message = MessageFormat.format(Messages.getString(id), arguments);
        } else {
            message = Messages.getString(id);
        }
        output(message);
    }

    /**
     * p^[̕ϊsB
     * f[^x[XɈˑ鎯ʎq̈lϊȂǂsB
     * @param pattern p^[
     * @return ϊꂽ
     * @throws SQLException SQL֘AG[ꍇ
     */
    protected final String convertPattern(String pattern) throws SQLException {
        String edited;
        DatabaseMetaData dbmeta = env.getCurrentConnection().getMetaData();
        if (dbmeta.storesLowerCaseIdentifiers()) {
            edited = pattern.toLowerCase();
        } else if (dbmeta.storesUpperCaseIdentifiers()) {
            edited = pattern.toUpperCase();
        } else {
            edited = pattern;
        }
        return edited.replace('*', '%').replace('?', '_');
    }

    /**
     * USAGE擾B
     * @param key L[[h
     * @return USAGE
     */
    protected static String getUsage(String key) {
        return Messages.getString("command." + key + ".usage");
    }

    /**
     * SQLSELECTǂ𒲍B
     * @param sql SQL
     * @return SQLSELECTȂ<code>true</code>AłȂ<code>false</code>
     */
    protected static boolean isSelect(String sql) {
        if (sql != null && sql.length() >= SELECT_LENGTH) {
            return SELECT.equalsIgnoreCase(sql.substring(0, SELECT_LENGTH));
        }
        return false;
    }

}