package net.argius.stew;

import java.io.*;

import javax.crypto.*;

import net.argius.logging.*;

/**
 * ÍgppX[h̊B
 */
public abstract class CipherPassword implements Password {

    private static final Logger log = LoggerFactory.getLogger(CipherPassword.class);

    private static String secretKey = "";

    private String transformedString;

    /* (overridden)
     * @see net.argius.stew.Password#getTransformedString()
     */
    public final String getTransformedString() {
        if (transformedString != null) {
            return transformedString;
        } else {
            return "";
        }
    }

    /* (overridden)
     * @see net.argius.stew.Password#setTransformedString(java.lang.String)
     */
    public final void setTransformedString(String transformedString) {
        if (transformedString != null) {
            this.transformedString = transformedString;
        }
    }

    /* (overridden)
     * @see net.argius.stew.Password#getRowString()
     */
    public final String getRowString() {
        if (transformedString != null) {
            return decrypt(transformedString);
        } else {
            return "";
        }
    }

    /* (overridden)
     * @see net.argius.stew.Password#setRowString(java.lang.String)
     */
    public final void setRowString(String rowString) {
        if (rowString != null) {
            this.transformedString = encrypt(rowString);
        }
    }

    /* (overridden)
     * @see net.argius.stew.Password#hasPassword()
     */
    public final boolean hasPassword() {
        return transformedString != null;
    }

    /**
     * 閧̐ݒB
     * @param secretKey 閧
     */
    public static void setSecretKey(String secretKey) {
        if (!StringClass.isEmpty(secretKey)) {
            CipherPassword.secretKey = secretKey;
        }
    }

    /**
     * ÍB
     * @param rowString 
     * @return Íꂽ
     */
    private String encrypt(String rowString) {
        try {
            Cipher cipher = getCipherInstance(secretKey, Cipher.ENCRYPT_MODE);
            byte[] encrypted = cipher.doFinal(rowString.getBytes());
            return toHexString(encrypted);
        } catch (Exception ex) {
            log.warn("", ex);
            return "";
        }
    }

    /**
     * B
     * @param cryptedString Íꂽ
     * @return 
     */
    private String decrypt(String cryptedString) {
        try {
            Cipher cipher = getCipherInstance(secretKey, Cipher.DECRYPT_MODE);
            byte[] decrypted = cipher.doFinal(toBytes(cryptedString));
            return new String(decrypted);
        } catch (Exception ex) {
            log.warn("", ex);
            return "";
        }
    }

    /**
     * oCgz16iɕϊB
     * @param bytes oCgz
     * @return oCgz16i
     */
    private static String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            byte b = bytes[i];
            buffer.append(0 <= b && b < 16 ? "0" : "");
            buffer.append(Integer.toHexString(b & 0xFF));
        }
        return buffer.toString();
    }

    /**
     * 16ioCgzɕϊB
     * @param hexString 16i
     * @return oCgz
     */
    private static byte[] toBytes(String hexString) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < hexString.length(); i += 2) {
            String s = hexString.substring(i, i + 2);
            bos.write(Integer.parseInt(s, 16));
        }
        return bos.toByteArray();
    }

    /**
     * CipherCX^X̎擾B
     * @param key 
     * @param mode Í/
     * @return CipherCX^X
     * @see Cipher
     */
    protected abstract Cipher getCipherInstance(String key, int mode);

}