package net.argius.logging;

import java.io.*;
import java.util.logging.*;
import java.util.logging.Logger;

/**
 * Logging API ̃bp[B
 * @see java.util.logging
 */
public final class LoggingApiWrapper extends BasicLogger {

    private final Logger logger;
    private final String targetClassName;

    /**
     * LoggingApiWrapper̐B
     * @param targetClassName ΏۃNX
     */
    public LoggingApiWrapper(String targetClassName) {
        this.logger = Logger.getLogger(targetClassName);
        this.targetClassName = targetClassName;
    }

    /* (overridden)
     * @see net.argius.logging.BasicLogger#printMessage(java.lang.String, java.lang.Object)
     */
    protected void printMessage(String levelString, Object object) {
        int lineNumber = getLineNumber(targetClassName);
        String lineNumberInfo = (lineNumber > 0) ? ":" + lineNumber : "";
        String message = "("
                         + levelString
                         + ") "
                         + "["
                         + targetClassName
                         + lineNumberInfo
                         + "] "
                         + object;
        logger.log(Level.FINEST, message);
    }

    /* (overridden)
     * @see net.argius.logging.BasicLogger#printStackTrace(java.lang.Throwable)
     */
    protected void printStackTrace(Throwable th) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        out.println();
        th.printStackTrace(out);
        logger.log(Level.FINEST, buffer.toString());
    }

}
