package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import net.argius.stew.*;
import net.argius.version.*;

/**
 * o[W̃ANVB
 */
public final class VersionInfoAction extends AbstractAction {

    private static final String FONT_FAMILY = "Arial";
    private static final Font FONT_L = new Font(FONT_FAMILY, Font.BOLD, 14);
    private static final Font FONT_M = new Font(FONT_FAMILY, Font.PLAIN, 12);
    private static final Font FONT_S = new Font(FONT_FAMILY, Font.PLAIN, 10);

    private final Component parent;

    /**
     * VersionInfoAction̐B
     * @param parent
     */
    public VersionInfoAction(Component parent) {
        this.parent = parent;
    }

    /* (overridden)
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {
        Version version = Version.getInstance(Launcher.class);
        // x
        String productInfo = Constants.PRODUCT_DETAIL_NAME;
        String versionInfo = "version " + version.getRegularString();
        String versionDetail = "build #"
                               + version.getBuildNumber()
                               + " : "
                               + new Date(version.getBuildTime());
        String copyrightInfo = Constants.COPYRIGHT;
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.setOpaque(false);
        JLabel labelProductName = createJLabel(productInfo, FONT_L);
        labelProductName.setForeground(new Color(64, 64, 192));
        panel.add(labelProductName);
        panel.add(createJLabel(versionInfo, FONT_M));
        panel.add(createJLabel(versionDetail, FONT_S));
        panel.add(new JLabel());
        panel.add(createJLabel(copyrightInfo, FONT_M));
        // _CAO\
        JOptionPane pane = new JOptionPane(panel,
                                           JOptionPane.INFORMATION_MESSAGE,
                                           JOptionPane.DEFAULT_OPTION);
        pane.setIcon(new MainIcon());
        JDialog dialog = pane.createDialog(parent, null);
        setupComponents(dialog);
        dialog.setVisible(true);
    }

    /**
     * eR|[lg̃ZbgAbvB
     * @param container Rei
     */
    private static void setupComponents(Container container) {
        for (int i = 0, n = container.getComponentCount(); i < n; i++) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                Container c = (Container)component;
                setupComponents(c);
            }
            component.setBackground(Color.WHITE);
        }
    }

    /**
     * JLabel̐B
     * @param text x
     * @param font tHg
     * @return JLabel
     */
    private static JLabel createJLabel(String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        return label;
    }

}