package net.argius.stew.gui;

import java.sql.*;
import java.util.*;
import java.util.Map.*;
import java.util.regex.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * ʃZbge[ůĎB
 * 
 * [UɂTable̕ҏWĎAύXef[^x[XɔfB
 * ̓IȎƂẮAvC}L[pāAtH[̕ύXe̍XV݂B
 * ̂߁AvC}L[łȂꍇ́AύXłȂԂɂȂB
 * ̏ł́AgUNV̊Ǘ͍sȂB
 * 
 * @see net.argius.stew.gui.ResultSetTable
 */
final class ResultSetTableMonitor {

    private static final Logger log = LoggerFactory.getLogger(ResultSetTableMonitor.class);
    private static final String PTN1 = "^.*\\s*SELECT\\s*.+\\s*FROM\\s*(.+)$";
    private static final String PROPERTY_TIMEOUT = ResultSetTableMonitor.class.getName()
                                                   + ".timeout";
    private static final int TIMEOUT_DEFAULT = 10;

    private final int timeout;

    private boolean isUpdatable;
    private String tableName;
    private String[] primaryKeys;
    private Connection conn;

    /**
     * ResultSetTableMonitor̐B
     */
    ResultSetTableMonitor() {
        this.isUpdatable = false;
        this.tableName = StringClass.EMPTY;
        this.primaryKeys = new String[0];
        int timeout;
        try {
            String property = LocalSystem.getProperty(PROPERTY_TIMEOUT);
            if (StringClass.isBlank(property)) {
                timeout = TIMEOUT_DEFAULT;
            } else {
                timeout = Integer.parseInt(property);
            }
        } catch (NumberFormatException ex) {
            timeout = TIMEOUT_DEFAULT;
        }
        this.timeout = timeout;
    }

    /**
     * sB
     * @param rs ʃZbg
     * @param cmd R}h
     * @throws SQLException SQL֘AG[ꍇ
     */
    synchronized void prepare(ResultSet rs, String cmd) throws SQLException {
        if (rs == null) {
            return;
        }
        Statement stmt = rs.getStatement();
        if (stmt == null) {
            return;
        }
        Connection conn = stmt.getConnection();
        if (conn == null) {
            return;
        }
        if (conn.isReadOnly()) {
            return;
        }
        String tableName = findTableName(cmd);
        if (StringClass.isEmpty(tableName)) {
            return;
        }
        String[] keys = findPrimaryKeys(conn, tableName);
        if (keys.length < 1) {
            return;
        }
        if (findUnion(cmd)) {
            return;
        }
        this.tableName = tableName;
        this.primaryKeys = keys;
        this.conn = conn;
        this.isUpdatable = true;
    }

    /**
     * e[u̒TB
     * SELECTP̃e[ułꍇ̂݁Ae[uԂB
     * @param cmd R}h
     * @return e[u łȂꍇ͋󕶎 
     */
    private static String findTableName(String cmd) {
        if (cmd != null) {
            Pattern p = Pattern.compile(PTN1, Pattern.CASE_INSENSITIVE);
            Matcher m = p.matcher(cmd);
            if (m.find()) {
                String afterFrom = m.group(1);
                String[] words = afterFrom.split("\\s");
                boolean foundComma = false;
                for (int i = 0; i < 2 && i < words.length; i++) {
                    String word = words[i];
                    if (word.indexOf(',') >= 0) {
                        foundComma = true;
                    }
                }
                if (!foundComma) {
                    String word = words[0];
                    if (word.matches("[A-Za-z0-9_\\.]+")) {
                        return word;
                    }
                }
            }
        }
        return StringClass.EMPTY;
    }

    /**
     * vC}L[̒TB
     * P̃e[uׂẴvC}L[łꍇ̂݁Ae[uԂB
     * @param conn RlNV
     * @param tableName e[u
     * @return vC}L[ꗗ łȂꍇ̓[z 
     * @throws SQLException SQL֘AG[ꍇ
     */
    private static String[] findPrimaryKeys(Connection conn, String tableName) throws SQLException {
        // ݒ
        DatabaseMetaData dbmeta = conn.getMetaData();
        String schema = dbmeta.getUserName();
        if (schema == null) {
            schema = StringClass.EMPTY;
        }
        String schemaCondition;
        String tableNameCondition;
        if (dbmeta.storesLowerCaseIdentifiers()) {
            schemaCondition = schema.toLowerCase();
            tableNameCondition = tableName.toLowerCase();
        } else if (dbmeta.storesUpperCaseIdentifiers()) {
            schemaCondition = schema.toUpperCase();
            tableNameCondition = tableName.toUpperCase();
        } else {
            schemaCondition = schema;
            tableNameCondition = tableName;
        }
        if (tableNameCondition.indexOf('.') >= 0) {
            String[] splitted = tableNameCondition.split("\\.");
            schemaCondition = splitted[0];
            tableNameCondition = splitted[1];
        }
        // 
        String[] result1 = getPrimaryKeys(dbmeta,
                                          schemaCondition,
                                          tableNameCondition);
        if (result1.length > 0) {
            return result1;
        } else {
            return getPrimaryKeys(dbmeta, null, tableNameCondition);
        }
    }

    /**
     * UNIONL[[h̒TB
     * @param sql SQL
     * @return UNIONL[[hꍇ <code>true</code>A
     *         Ȃꍇ <code>false</code>
     */
    private static boolean findUnion(String sql) {
        String s = sql;
        if (s.indexOf("'") >= 0) {
            if (s.indexOf("\\'") >= 0) {
                s = s.replaceAll("\\'", "");
            }
            s = s.replaceAll("'[^']+'", "''");
        }
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase("UNION")) {
                return true;
            }
        }
        return false;
    }

    /**
     * vC}L[̎擾B
     * @param dbmeta DatabaseMetaData
     * @param schema XL[}
     * @param table e[u
     * @return vC}L[ꗗ
     * @throws SQLException SQL֘AG[ꍇ
     */
    private static String[] getPrimaryKeys(DatabaseMetaData dbmeta,
                                           String schema,
                                           String table) throws SQLException {
        ResultSet rs = dbmeta.getPrimaryKeys(null, schema, table);
        try {
            List pkList = new ArrayList();
            Set schemaSet = new HashSet();
            while (rs.next()) {
                pkList.add(rs.getString(4));
                schemaSet.add(rs.getString(2));
            }
            if (schemaSet.size() < 2) {
                return (String[])pkList.toArray(new String[pkList.size()]);
            }
        } finally {
            rs.close();
        }
        return new String[0];
    }

    /**
     * Kvȏꍇ͈pň͂ށB
     * @param string 
     * @return ꂽ
     */
    private static String quoteIfNeeds(String string) {
        if (string != null && string.indexOf('-') >= 0) {
            return '"' + string + '"';
        }
        return string;
    }

    /**
     * s(1)XVB
     * w肵s̎w肵ΏۂɁAK1sXV݂B
     * XVs1ȊȌꍇ̓G[ƂB
     * @param rowData XVΏۂ̍sf[^
     * @param target XVΏۂ̖Otl
     * @throws SQLException SQL֘AG[ꍇ
     */
    void update(Map rowData, NamedValue target) throws SQLException {
        // Ó
        checkConnection();
        // SQL
        String targetKey = target.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ");
        buffer.append(tableName);
        buffer.append(" SET ");
        buffer.append(quoteIfNeeds(targetKey));
        buffer.append("=? WHERE ");
        for (int i = 0; i < primaryKeys.length; i++) {
            if (i > 0) {
                buffer.append(" AND ");
            }
            buffer.append(quoteIfNeeds(primaryKeys[i]));
            buffer.append("=?");
        }
        String sql = buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + sql);
            log.debug("parameter : " + target);
        }
        // s
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setQueryTimeout(timeout);
            int index = 1;
            Object value = target.getValue();
            if (value == null) {
                stmt.setNull(index++, Types.CHAR);
            } else {
                stmt.setObject(index++, value);
            }
            for (int i = 0; i < primaryKeys.length; i++) {
                stmt.setObject(index++, rowData.get(primaryKeys[i]));
            }
            int updated = stmt.executeUpdate();
            checkUpdateCount(updated);
        } finally {
            stmt.close();
        }
    }

    /**
     * s(1)XVB
     * w肵s̎w肵ΏۂɁAK1sXV݂B
     * XVs1ȊȌꍇ̓G[ƂB
     * @param rowData XVΏۂ̍sf[^
     * @param targets XVΏۂ̖Otl̔z
     * @throws SQLException SQL֘AG[ꍇ
     */
    void update(Map rowData, NamedValue[] targets) throws SQLException {
        // Ó
        checkConnection();
        // SQL
        List list = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ");
        buffer.append(tableName);
        buffer.append(" SET ");
        for (int i = 0, n = targets.length; i < n; i++) {
            if (i > 0) {
                buffer.append(", ");
            }
            NamedValue target = targets[i];
            buffer.append(quoteIfNeeds(target.getName()));
            buffer.append("=?");
            list.add(target.getValue());
        }
        buffer.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; i++) {
            if (i > 0) {
                buffer.append(" AND ");
            }
            buffer.append(quoteIfNeeds(primaryKeys[i]));
            buffer.append("=?");
        }
        String sql = buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + sql);
            log.debug("parameter : " + list);
        }
        // s
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setQueryTimeout(timeout);
            int index = 1;
            for (int i = 0, n = list.size(); i < n; i++) {
                Object value = list.get(i);
                if (value == null) {
                    stmt.setNull(index++, Types.CHAR);
                } else {
                    stmt.setObject(index++, value);
                }
            }
            for (int i = 0; i < primaryKeys.length; i++) {
                stmt.setObject(index++, rowData.get(primaryKeys[i]));
            }
            int updated = stmt.executeUpdate();
            checkUpdateCount(updated);
        } finally {
            stmt.close();
        }
    }

    /**
     * s}B
     * XVs1ȊȌꍇ̓G[ƂB
     * @param rowData }sf[^
     * @throws SQLException SQL֘AG[ꍇ
     */
    void insert(Map rowData) throws SQLException {
        // Ó
        checkConnection();
        // SQL
        List list = new ArrayList();
        for (Iterator it = rowData.entrySet().iterator(); it.hasNext();) {
            Entry entry = (Entry)it.next();
            Object value = entry.getValue();
            if (value != null) {
                list.add(entry);
            }
        }
        Entry[] entries = (Entry[])list.toArray(new Entry[list.size()]);
        int entryCount = entries.length;
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ");
        buffer.append(tableName);
        buffer.append(" (");
        StringBuffer subBuffer = new StringBuffer();
        for (int i = 0; i < entryCount; i++) {
            if (i > 0) {
                buffer.append(',');
                subBuffer.append(',');
            }
            String key = (String)entries[i].getKey();
            buffer.append(quoteIfNeeds(key));
            subBuffer.append('?');
        }
        buffer.append(") VALUES (");
        buffer.append(subBuffer);
        buffer.append(')');
        String sql = buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + sql);
            log.debug("parameter : " + rowData);
        }
        // s
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setQueryTimeout(timeout);
            for (int i = 0; i < entryCount; i++) {
                stmt.setObject(i + 1, entries[i].getValue());
            }
            int inserted = stmt.executeUpdate();
            checkUpdateCount(inserted);
        } finally {
            stmt.close();
        }
    }

    /**
     * s폜B
     * XVs1ȊȌꍇ̓G[ƂB
     * @param rowData 폜sf[^
     * @throws SQLException SQL֘AG[ꍇ
     */
    void delete(Map rowData) throws SQLException {
        // Ó
        checkConnection();
        // SQL
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ");
        buffer.append(tableName);
        buffer.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; i++) {
            if (i > 0) {
                buffer.append(" AND ");
            }
            buffer.append(quoteIfNeeds(primaryKeys[i]));
            buffer.append("=?");
        }
        String sql = buffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + sql);
        }
        // s
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setQueryTimeout(timeout);
            for (int i = 0; i < primaryKeys.length; i++) {
                stmt.setObject(i + 1, rowData.get(primaryKeys[i]));
            }
            int deleted = stmt.executeUpdate();
            checkUpdateCount(deleted);
        } finally {
            stmt.close();
        }
    }

    /**
     * RlNV̊mFB
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void checkConnection() throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw new SQLException("connection is already closed");
        }
    }

    /**
     * XVJEg̊mFB
     * @param updatedCount XVJEg
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void checkUpdateCount(int updatedCount) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("updated count = " + updatedCount);
        }
        if (updatedCount != 1) {
            throw new SQLException("incorrect count : " + updatedCount);
        }
    }

    /**
     * \̃e[uXV\ǂ𒲍B
     * @return \̃e[uXV\Ȃ<code>true</code>A
     *         łȂ<code>false</code>
     */
    boolean isUpdatable() {
        return isUpdatable;
    }

    /**
     * e[u̎擾B
     * @return e[u
     */
    String getTableName() {
        return tableName;
    }

    /**
     * vC}L[ꗗ̎擾B
     * @return vC}L[ꗗ
     */
    String[] getPrimaryKeys() {
        return (String[])primaryKeys.clone();
    }

}