package net.argius.stew.gui;

import java.awt.event.*;
import java.io.*;
import java.text.*;

import javax.swing.*;
import javax.swing.JSpinner.*;
import javax.swing.text.*;

import net.argius.stew.*;

/**
 * j[B
 * j[o[Ƃ̃Cxg𐶐B
 */
final class Menu extends JMenuBar {

    static final int DEFAULT_LIMIT_COUNT = 1000;

    final JCheckBoxMenuItem checkBoxStatusBarVisibility;
    final JCheckBoxMenuItem checkBoxShowColumnNumber;

    private final Environment env;
    private final WindowOutputProcessor op;
    private final Window window;
    private final ConsoleTextArea consoleTextArea;
    private final ResultSetTable resultSetTable;
    private final JLabel statusBarLabel;

    private final JSpinner viewLimitCountSpinner;
    private final ColumnAdjustModeButtonGroup columnAdjustModeButtonGroup;

    /**
     * Menu̐B
     * @param env s
     * @param op WindowOutputProcessor
     */
    Menu(Environment env, WindowOutputProcessor op) {
        this.env = env;
        this.op = op;
        this.window = op.window;
        this.consoleTextArea = op.consoleTextArea;
        this.resultSetTable = op.resultSetTable;
        this.statusBarLabel = op.statusBarLabel;
        // File
        JMenu mFile = createJMenu(getMessage("file"), 'F');
        add(mFile);
        mFile.add(createJMenuItem(getMessage("file.newwindow"),
                                  'N',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuNewWindowSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_N, true)));
        mFile.add(createJMenuItem(getMessage("file.close"),
                                  'C',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuCloseSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_W, true)));
        mFile.add(new JSeparator());
        mFile.add(createJMenuItem(getMessage("file.chdir"),
                                  'D',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuChangeDirectorySelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_D, true)));
        mFile.add(createJMenuItem(getMessage("file.export"),
                                  'E',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuExportSelected();
                                      }

                                  }));
        mFile.add(new JSeparator());
        mFile.add(createJMenuItem(getMessage("file.quit"),
                                  'Q',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuQuitSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_Q, true)));
        // Edit
        JMenu mEdit = createJMenu(getMessage("edit"), 'E');
        add(mEdit);
        mEdit.add(createJMenuItem(getMessage("edit.cut"),
                                  'T',
                                  new DefaultEditorKit.CutAction(),
                                  getKeyStroke(KeyEvent.VK_X, true)));
        mEdit.add(createJMenuItem(getMessage("edit.copy"),
                                  'C',
                                  new DefaultEditorKit.CopyAction(),
                                  getKeyStroke(KeyEvent.VK_C, true)));
        mEdit.add(createJMenuItem(getMessage("edit.paste"),
                                  'P',
                                  new DefaultEditorKit.PasteAction(),
                                  getKeyStroke(KeyEvent.VK_P, true)));
        mEdit.add(new JSeparator());
        mEdit.add(createJMenuItem(getMessage("edit.gotoedit"),
                                  'G',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuGoToInputAreaSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_G, true)));
        mEdit.add(createJMenuItem(getMessage("edit.clear"),
                                  'M',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuClearSelected();
                                      }

                                  }));
        // View
        JMenu mView = createJMenu(getMessage("view"), 'V');
        add(mView);
        checkBoxStatusBarVisibility = createJCheckBoxMenuItem(getMessage("view.statusbar"),
                                                              op.statusBarLabel.isVisible(),
                                                              'B',
                                                              new AbstractAction() {

                                                                  public void actionPerformed(ActionEvent e) {
                                                                      onMenuStatusBarSelected(e);
                                                                  }

                                                              },
                                                              null);
        mView.add(checkBoxStatusBarVisibility);
        mView.add(new JSeparator());
        checkBoxShowColumnNumber = createJCheckBoxMenuItem(getMessage("view.columnnumber"),
                                                           false,
                                                           'C',
                                                           new AbstractAction() {

                                                               public void actionPerformed(ActionEvent e) {
                                                                   onMenuShowColumnNumberSelected();
                                                               }

                                                           },
                                                           null);
        mView.add(checkBoxShowColumnNumber);
        mView.add(createJMenuItem(getMessage("view.widen"),
                                  'W',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuWidenSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_PERIOD, true)));
        mView.add(createJMenuItem(getMessage("view.narrow"),
                                  'N',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuNarrowSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_COMMA, true)));
        mView.add(createJMenuItem(getMessage("view.adjustcolumnwidth"),
                                  'A',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuAdjustColumnWidthSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_SLASH, true)));
        JMenu viewColumnAdjustMode = createJMenu(getMessage("view.columnautoadjustmentmode"),
                                                 'M');
        mView.add(viewColumnAdjustMode);
        columnAdjustModeButtonGroup = new ColumnAdjustModeButtonGroup(this,
                                                                      viewColumnAdjustMode);
        mView.add(new JSeparator());
        viewLimitCountSpinner = new JSpinner(new SpinnerNumberModel(DEFAULT_LIMIT_COUNT,
                                                                    1,
                                                                    Integer.MAX_VALUE,
                                                                    500));
        mView.add(createJMenuItem(getMessage("view.limitcount"),
                                  'L',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSetLimitCountSelected();
                                      }

                                  }));
        mView.add(createJMenuItem(getMessage("view.font"),
                                  'F',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuChangeFontSelected();
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_SEMICOLON, true)));
        // Connect
        JMenu mConnect = createJMenu(getMessage("connect"), 'C');
        add(mConnect);
        mConnect.add(createJMenuItem(getMessage("connect.connect"),
                                     'C',
                                     new ConnectorListAction(op, env),
                                     getKeyStroke(KeyEvent.VK_SPACE, true)));
        mConnect.add(createJMenuItem(getMessage("connect.disconnect"),
                                     'D',
                                     new AbstractAction() {

                                         public void actionPerformed(ActionEvent e) {
                                             onMenuDisconnectSelected();
                                         }

                                     }));
        mConnect.add(new JSeparator());
        mConnect.add(createJMenuItem(getMessage("connect.encryptionkey"),
                                     'K',
                                     new AbstractAction() {

                                         public void actionPerformed(ActionEvent e) {
                                             onMenuEncryptionKeySelected();
                                         }

                                     }));
        mConnect.add(createJMenuItem(getMessage("connect.configuration"),
                                     'E',
                                     new AbstractAction() {

                                         public void actionPerformed(ActionEvent e) {
                                             onMenuConnectorConfigurationSelected();
                                         }

                                     }));
        // Command
        JMenu mCmd = createJMenu(getMessage("command"), 'M');
        add(mCmd);
        mCmd.add(createJMenuItem(getMessage("command.execute"),
                                 'X',
                                 new AbstractAction() {

                                     public void actionPerformed(ActionEvent e) {
                                         onMenuCommandExecuteSelected();
                                     }

                                 },
                                 getKeyStroke(KeyEvent.VK_M, true)));
        mCmd.add(new JSeparator());
        mCmd.add(createJMenuItem(getMessage("command.history.previous"),
                                 'P',
                                 new AbstractAction() {

                                     public void actionPerformed(ActionEvent e) {
                                         onMenuCommandPreviousHistorySelected();
                                     }

                                 },
                                 getKeyStroke(KeyEvent.VK_K, true)));
        mCmd.add(createJMenuItem(getMessage("command.history.next"),
                                 'N',
                                 new AbstractAction() {

                                     public void actionPerformed(ActionEvent e) {
                                         onMenuCommandNextHistorySelected();
                                     }

                                 },
                                 getKeyStroke(KeyEvent.VK_J, true)));
        // Help
        JMenu mHelp = createJMenu(getMessage("help"), 'H');
        add(mHelp);
        mHelp.add(createJMenuItem(getMessage("help.showhelp"),
                                  'H',
                                  new HelpInfoAction(window)));
        mHelp.add(new JSeparator());
        mHelp.add(createJMenuItem(getMessage("help.about"),
                                  'A',
                                  new VersionInfoAction(window)));
        // end
        loadConfiguration();
        validate();
    }

    /**
     * ݒ̕B
     */
    private void loadConfiguration() {
        try {
            MenuConfiguration.load(this, env.getSystemDirectory());
        } catch (IOException ex) {
            op.onError(ex);
        }
    }

    /**
     * ݒ̕ۑB
     */
    private void saveConfiguration() {
        try {
            MenuConfiguration.save(this, env.getSystemDirectory());
        } catch (IOException ex) {
            op.onError(ex);
        }
    }

    /**
     * JMenu̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @return JMenu
     */
    private static JMenu createJMenu(String caption, char mnemonic) {
        JMenu menu = new JMenu(caption);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption,
                                             char mnemonic,
                                             Action action) {
        return createJMenuItem(caption, mnemonic, action, null);
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @param shortcut V[gJbgL[
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption,
                                             char mnemonic,
                                             Action action,
                                             KeyStroke shortcut) {
        JMenuItem item = new JMenuItem(caption, mnemonic);
        if (action != null) {
            item.addActionListener(action);
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    /**
     * JCheckBoxMenuItem̐B
     * @param caption \
     * @param selected I
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @param shortcut V[gJbgL[
     * @return JCheckBoxMenuItem
     */
    private static JCheckBoxMenuItem createJCheckBoxMenuItem(String caption,
                                                             boolean selected,
                                                             char mnemonic,
                                                             Action action,
                                                             KeyStroke shortcut) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(caption, selected);
        item.setMnemonic(mnemonic);
        if (action != null) {
            item.addActionListener(action);
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    /**
     * KeyStroke̎擾B
     * @param key L[
     * @param withControlKey Rg[L[gpꍇ <code>true</code>
     * @return KeyStroke
     */
    private static KeyStroke getKeyStroke(int key, boolean withControlKey) {
        return KeyStroke.getKeyStroke(key, (withControlKey
                ? InputEvent.CTRL_MASK
                : 0));
    }

    /**
     * R}h̎svB
     * @param command R}h
     */
    private void requestCommand(String command) {
        op.requestCommand(command, "menu:" + command);
    }

    /**
     * j["VEBhE"ȈB
     */
    void onMenuNewWindowSelected() {
        op.createNew();
    }

    /**
     * j[""ȈB
     */
    void onMenuCloseSelected() {
        op.onWindowClosing();
    }

    /**
     * j["fBNg̕ύX"ȈB
     */
    void onMenuChangeDirectorySelected() {
        File currentDirectory = env.getCurrentDirectory();
        JFileChooser fileChooser = new JFileChooser(currentDirectory);
        fileChooser.setDialogTitle(getMessage("dialog.chdir.title"));
        fileChooser.setApproveButtonText(getMessage("dialog.chdir.button"));
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fileChooser.showDialog(this, null);
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            env.setCurrentDirectory(file);
        }
    }

    /**
     * j["GNX|[g"ȈB
     */
    void onMenuExportSelected() {
        File currentDirectory = env.getCurrentDirectory();
        JFileChooser fileChooser = new JFileChooser(currentDirectory);
        fileChooser.setDialogTitle(getMessage("dialog.export.title"));
        fileChooser.setApproveButtonText(getMessage("dialog.export.button"));
        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fileChooser.showDialog(this, null);
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            if (file.exists()) {
                String message = getMessage("message.confirm.overwritefile");
                if (DialogMessage.confirmYesNo(window, message) != JOptionPane.YES_OPTION) {
                    return;
                }
            }
            try {
                resultSetTable.export(file);
                DialogMessage.notice(window,
                                     getMessage("message.notice.exported"));
            } catch (IOException ex) {
                op.onError(ex);
            }
        }
    }

    /**
     * j["I"ȈB
     */
    void onMenuQuitSelected() {
        String message = getMessage("message.exit");
        int result = DialogMessage.confirmYesNo(window, message);
        if (result == JOptionPane.OK_OPTION) {
            op.requestExit();
        }
    }

    /**
     * j["͗Ɉړ"ȈB
     */
    void onMenuGoToInputAreaSelected() {
        consoleTextArea.requestFocus();
    }

    /**
     * j["bZ[W̃NA"ȈB
     */
    void onMenuClearSelected() {
        consoleTextArea.clear();
        consoleTextArea.sendCommand();
    }

    /**
     * j["񕝂g"ȈB
     */
    void onMenuWidenSelected() {
        resultSetTable.changeColumnWidth(3 / 2d);
    }

    /**
     * j["񕝂k"ȈB
     */
    void onMenuNarrowSelected() {
        resultSetTable.changeColumnWidth(2 / 3d);
    }

    /**
     * j["񕝂̒"ȈB
     */
    void onMenuAdjustColumnWidthSelected() {
        resultSetTable.adjustColumnWidth();
    }

    /**
     * j["ő\̐ݒ"ȈB
     */
    void onMenuSetLimitCountSelected() {
        SpinnerNumberModel model = (SpinnerNumberModel)viewLimitCountSpinner.getModel();
        int value = model.getNumber().intValue();
        JOptionPane pane = new JOptionPane(viewLimitCountSpinner,
                                           JOptionPane.PLAIN_MESSAGE,
                                           JOptionPane.OK_CANCEL_OPTION);
        final JDialog dialog = pane.createDialog(window, null);
        final DefaultEditor editor = (DefaultEditor)viewLimitCountSpinner.getEditor();
        editor.getTextField().addKeyListener(new KeyAdapter() {

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case KeyEvent.VK_ENTER:
                        try {
                            editor.commitEdit();
                        } catch (ParseException ex) {
                            DialogMessage.alert(editor, ex.toString());
                        }
                        dialog.dispose();
                        break;
                    case KeyEvent.VK_ESCAPE:
                        dialog.dispose();
                        break;
                    default:
                }
            }

        });
        dialog.setVisible(true);
        pane.getInputValue();
        int commitedValue = model.getNumber().intValue();
        if (commitedValue != value) {
            setLimitCount(commitedValue);
        }
    }

    /**
     * j["tHg"ȈB
     */
    void onMenuChangeFontSelected() {
        op.requestShowFontChooser();
    }

    /**
     * j["Xe[^Xo["ȈB
     * @param e Cxg
     */
    void onMenuStatusBarSelected(ActionEvent e) {
        statusBarLabel.setVisible(!statusBarLabel.isVisible());
        Object source = e.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)source;
            item.setState(statusBarLabel.isVisible());
        }
    }

    /**
     * j["ԍ̕\"ȈB
     */
    void onMenuShowColumnNumberSelected() {
        boolean b = resultSetTable.isShowColumnNumber();
        resultSetTable.setShowColumnNumber(!b);
        resultSetTable.repaint();
    }

    /**
     * j["ؒf"ȈB
     */
    void onMenuDisconnectSelected() {
        requestCommand("disconnect");
    }

    /**
     * j["Í"ȈB
     */
    void onMenuEncryptionKeySelected() {
        JPasswordField password = new JPasswordField(20);
        Object[] objects = {getMessage("dialog.encryption.message"), password};
        JOptionPane pane = new JOptionPane(objects,
                                           JOptionPane.PLAIN_MESSAGE,
                                           JOptionPane.OK_CANCEL_OPTION);
        pane.createDialog(window, null).setVisible(true);
        Object value = pane.getValue();
        if (value != null && value instanceof Number) {
            Number result = (Number)value;
            if (result.intValue() == JOptionPane.OK_OPTION) {
                char[] chars = password.getPassword();
                CipherPassword.setSecretKey(String.valueOf(chars));
            }
        }
    }

    /**
     * j["ڑݒ"ȈB
     */
    void onMenuConnectorConfigurationSelected() {
        if (env.getCurrentConnector() != null) {
            DialogMessage.notice(window,
                                 getMessage("message.notice.starteditconnector"));
        }
        op.requestShowConnectorMapEditDialog();
        env.loadConnectorMap();
    }

    /**
     * j["s"(R}h)ȈB
     */
    void onMenuCommandExecuteSelected() {
        consoleTextArea.sendCommand();
    }

    /**
     * j["O̗"ȈB
     */
    void onMenuCommandPreviousHistorySelected() {
        consoleTextArea.turnBackHistory();
    }

    /**
     * j["̗"ȈB
     */
    void onMenuCommandNextHistorySelected() {
        consoleTextArea.turnNextHistory();
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("menu.Menu." + key);
    }

    /**
     * ő\̎擾B
     * @return limitCount ő\
     */
    int getLimitCount() {
        return resultSetTable.getLimitCount();
    }

    /**
     * ő\̐ݒB
     * @param limitCount ő\
     */
    void setLimitCount(int limitCount) {
        resultSetTable.setLimitCount(limitCount);
        viewLimitCountSpinner.setValue(new Integer(limitCount));
        saveConfiguration();
    }

    /**
     * 񕝒[h̎擾B
     * @return 񕝒[h
     */
    String getColumnAdjustMode() {
        return resultSetTable.getColumnAdjustMode();
    }

    /**
     * 񕝒[h̐ݒB
     * @param columnAdjustMode 񕝒[h
     */
    void setColumnAdjustMode(String columnAdjustMode) {
        resultSetTable.setColumnAdjustMode(columnAdjustMode);
        columnAdjustModeButtonGroup.setMode(columnAdjustMode);
        saveConfiguration();
    }

    /**
     * 񕝎̑IO[vB
     */
    static final class ColumnAdjustModeButtonGroup extends ButtonGroup {

        final Menu menu;
        final JRadioButtonMenuItem[] radios;

        ColumnAdjustModeButtonGroup(Menu menu, JMenuItem item) {
            this.menu = menu;
            String prefix = "view.columnautoadjustmentmode";
            JRadioButtonMenuItem[] radios = {
                                             createJRadioButtonMenuItem(getMessage(prefix
                                                                                   + ".none"),
                                                                        false,
                                                                        'N'),
                                             createJRadioButtonMenuItem(getMessage(prefix
                                                                                   + ".header"),
                                                                        false,
                                                                        'H'),
                                             createJRadioButtonMenuItem(getMessage(prefix
                                                                                   + ".value"),
                                                                        false,
                                                                        'V')};
            for (int i = 0; i < radios.length; i++) {
                JRadioButtonMenuItem radio = radios[i];
                item.add(radio);
                add(radio);
                final int index = i;
                radio.addActionListener(new ActionListener() {

                    public void actionPerformed(ActionEvent e) {
                        onMenuColumnAdjustModeSelected(getMode(index));
                    }

                });
            }
            this.radios = radios;
        }

        /**
         * IĂ郂[hl̎擾B
         * @return [hl
         */
        String getMode() {
            for (int i = 0; i < radios.length; i++) {
                if (radios[i].isSelected()) {
                    return getMode(i);
                }
            }
            return "";
        }

        /**
         * [hl̎擾
         * @param i CfbNX
         * @return [hl
         */
        String getMode(int i) {
            switch (i) {
                case 0:
                    return "NONE";
                case 1:
                    return "HEADER";
                case 2:
                    return "VALUE";
                default:
                    return "";
            }
        }

        /**
         * [hl̐ݒ
         * @param mode [hl
         */
        void setMode(String mode) {
            int index;
            if (mode.equalsIgnoreCase("NONE")) {
                index = 0;
            } else if (mode.equalsIgnoreCase("HEADER")) {
                index = 1;
            } else if (mode.equalsIgnoreCase("VALUE")) {
                index = 2;
            } else {
                index = -1;
            }
            if (index >= 0) {
                radios[index].setSelected(true);
            }
        }

        /**
         * j["񕝎"ȈB
         * @param mode [hl
         */
        void onMenuColumnAdjustModeSelected(String mode) {
            menu.setColumnAdjustMode(mode);
        }

        /**
         * JRadioButtonMenuItem̐B
         * @param caption \
         * @param selected I
         * @param mnemonic 蓖ĕ
         * @return JRadioButtonMenuItem
         */
        private static JRadioButtonMenuItem createJRadioButtonMenuItem(String caption,
                                                                       boolean selected,
                                                                       char mnemonic) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(caption);
            item.setMnemonic(mnemonic);
            item.setSelected(selected);
            return item;
        }

        /**
         * (O)bZ[W̎擾B
         * @param key L[
         * @return bZ[W
         */
        private static String getMessage(String key) {
            return Messages.getString("menu.Menu." + key);
        }

    }

}