package net.argius.stew.gui;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;

import net.argius.logging.*;
import net.argius.stew.io.*;

/**
 * ReLXgj[B
 */
final class ContextMenu extends MouseAdapter {

    private static final Logger log = LoggerFactory.getLogger(ContextMenu.class);

    private final Component parent;

    /**
     * ContextMenu̐B
     * @param parent
     */
    ContextMenu(Component parent) {
        this.parent = parent;
    }

    /* (overridden)
     * @see java.awt.event.MouseAdapter#mouseClicked(java.awt.event.MouseEvent)
     */
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            Object source = e.getSource();
            if (source instanceof JTable) {
                showMenuForJTable((JTable)source, e);
            } else if (source instanceof JTableHeader) {
                showMenuForJTableHeader((JTableHeader)source, e);
            } else if (source instanceof JTextComponent) {
                showMenuForJTextComponent((JTextComponent)source, e);
            }
        }
    }

    /**
     * JTablep̃ReLXgj[\B
     * @param table KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTable(final JTable table, MouseEvent e) {
        final ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        final int x = e.getX();
        final int y = e.getY();
        final int selectedColumn = table.getSelectedColumn();
        final int selectedRow = table.getSelectedRow();
        final boolean isUpdatable = model.isUpdatable();
        final boolean isCellSelected = selectedColumn >= 0;
        final boolean isCellEditable = model.isCellEditable(selectedRow,
                                                            selectedColumn);
        final boolean isSelectedInsertRow = model.isInsertRow(selectedRow);
        final boolean isClipboardEnabled = isClipboardEnabled();
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(getMessage("table.copy.cell"),
                                  'C',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuCopySelectedCellValueSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_C, true)))
             .setEnabled(isCellSelected);
        popup.add(createJMenuItem(getMessage("table.paste.cell"),
                                  'P',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuPasteValueToSelectedCellSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_V, true)))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(getMessage("table.null.value"),
                                  'V',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuResetValueSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_R, true)))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(getMessage("table.select.all"),
                                  'S',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSelectAllSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_A, true)));
        popup.add(new JPopupMenu.Separator());
        popup.add(createJMenuItem(getMessage("table.add.newrow"),
                                  'N',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuAddNewRowSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable && !isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.add.duplicatedrow"),
                                  'A',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuCopyInsertRowSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable && !isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.insert.paste"),
                                  'O',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuInsertClipboardDataelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_I, true)))
             .setEnabled(isUpdatable
                         && isClipboardEnabled
                         && !isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.fix.insert"),
                                  'F',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuFixInsertSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable && isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.delete.row"),
                                  'D',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuDeleteRowSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable);
        popup.show(table, x, y);
    }

    /**
     * JTableHeaderp̃ReLXgj[\B
     * @param component KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTableHeader(JTableHeader component, MouseEvent e) {
        final JTable table = component.getTable();
        final ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        final int x = e.getX();
        final int y = e.getY();
        final int columnIndex = component.columnAtPoint(new Point(x, y));
        final boolean isUpdatable = model.isUpdatable();
        final boolean isClipboardEnabled = isClipboardEnabled();
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(getMessage("header.sort"),
                                  'S',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSortColumnSelected(table,
                                                                   columnIndex);
                                      }

                                  }));
        popup.add(createJMenuItem(getMessage("header.selectcolumn"),
                                  'C',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSelectColumnSelected(table,
                                                                     columnIndex);
                                      }

                                  }));
        popup.add(new JPopupMenu.Separator());
        popup.add(createJMenuItem(getMessage("table.add.newrow"),
                                  'N',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuAddNewRowSelected(table);
                                      }

                                  }))
             .setEnabled(isUpdatable);
        popup.add(createJMenuItem(getMessage("table.insert.paste"),
                                  'O',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuInsertClipboardDataelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_I, true)))
             .setEnabled(isUpdatable && isClipboardEnabled);
        popup.show(component, e.getX(), e.getY());
    }

    /**
     * JTextComponentp̃ReLXgj[\B
     * @param component KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTextComponent(Component component, MouseEvent e) {
        boolean isClipboardEnabled = isClipboardEnabled();
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(getMessage("text.cut"),
                                  'T',
                                  new DefaultEditorKit.CutAction(),
                                  getKeyStroke(KeyEvent.VK_X, true)));
        popup.add(createJMenuItem(getMessage("text.copy"),
                                  'C',
                                  new DefaultEditorKit.CopyAction(),
                                  getKeyStroke(KeyEvent.VK_C, true)));
        popup.add(createJMenuItem(getMessage("text.paste"),
                                  'P',
                                  new DefaultEditorKit.PasteAction(),
                                  getKeyStroke(KeyEvent.VK_V, true)))
             .setEnabled(isClipboardEnabled);
        popup.show(component, e.getX(), e.getY());
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption,
                                             char mnemonic,
                                             Action action) {
        return createJMenuItem(caption, mnemonic, action, null);
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @param shortcut V[gJbgL[
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption,
                                             char mnemonic,
                                             Action action,
                                             KeyStroke shortcut) {
        JMenuItem item = new JMenuItem(caption, mnemonic);
        if (action != null) {
            item.addActionListener(action);
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    /**
     * KeyStroke̎擾B
     * @param key L[
     * @param withControlKey Rg[L[gpꍇ <code>true</code>
     * @return KeyStroke
     */
    private static KeyStroke getKeyStroke(int key, boolean withControlKey) {
        return KeyStroke.getKeyStroke(key, (withControlKey
                ? InputEvent.CTRL_MASK
                : 0));
    }

    /**
     * Nbv{[hp\ǂ𒲍B
     * Nbv{[hef[^Ƃ݂Ȃꂽꍇɗp\ƂB
     * @return Nbv{[hp\Ȃ<code>true</code>AłȂ<code>false</code>
     */
    private static boolean isClipboardEnabled() {
        return Toolkit.getDefaultToolkit()
                      .getSystemClipboard()
                      .getContents(null)
                      .isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    /**
     * j["ZRs["IꂽƂ̏B
     * @param table e[u
     */
    void onMenuCopySelectedCellValueSelected(JTable table) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Exporter exporter = new SimpleExporter(bos, "\t");
        int[] selectedColumns = table.getSelectedColumns();
        int[] selectedRows = table.getSelectedRows();
        int columnCount = selectedColumns.length;
        try {
            for (int y = 0; y < selectedRows.length; y++) {
                int rowIndex = selectedRows[y];
                Object[] values = new Object[columnCount];
                for (int x = 0; x < columnCount; x++) {
                    int columnIndex = selectedColumns[x];
                    Object value = table.getValueAt(rowIndex, columnIndex);
                    if (value == null) {
                        value = "";
                    }
                    values[x] = value;
                }
                exporter.addRow(values);
            }
            String contents = bos.toString().replaceAll("\\r", "");
            if (log.isTraceEnabled()) {
                Writer buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                out.println("to clipboard:");
                out.print(contents);
                log.trace(buffer);
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit()
                                         .getSystemClipboard();
            StringSelection ss = new StringSelection(contents);
            clipboard.setContents(ss, ss);
        } catch (IOException ex) {
            onError(ex);
        }
    }

    /**
     * j["Z\t"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuPasteValueToSelectedCellSelected(JTable table) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipboard.getContents(null);
        try {
            String contents = (String)t.getTransferData(DataFlavor.stringFlavor);
            paste(table, contents);
        } catch (UnsupportedFlavorException ex) {
            onError(ex);
        } catch (IOException ex) {
            onError(ex);
        } catch (SQLException ex) {
            onError(ex);
        }
    }

    /**
     * \tsB
     * @param table e[u
     * @param contents \te
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void paste(JTable table, String contents) throws IOException, SQLException {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        Importer importer = new TabSeparatedTextImporter(contents);
        try {
            int[] selectedColumns = table.getSelectedColumns();
            int[] selectedRows = table.getSelectedRows();
            int columnCount = selectedColumns.length;
            for (int y = 0; y < selectedRows.length; y++) {
                int rowIndex = selectedRows[y];
                boolean isInsertRow = model.isInsertRow(rowIndex);
                Object[] values = importer.nextRow();
                int limit = Math.min(columnCount, values.length);
                for (int x = 0; x < limit; x++) {
                    int columnIndex = selectedColumns[x];
                    Object oldValue = table.getValueAt(rowIndex, columnIndex);
                    Object newValue = values[x];
                    if (!isInsertRow) {
                        model.updateValueChanged(table,
                                                 rowIndex,
                                                 columnIndex,
                                                 oldValue,
                                                 newValue);
                    }
                    table.setValueAt(newValue, rowIndex, columnIndex);
                }
            }
        } finally {
            importer.close();
        }
    }

    /**
     * j["ׂđI"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuSelectAllSelected(JTable table) {
        table.selectAll();
    }

    /**
     * j["Null̐ݒ"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuResetValueSelected(JTable table) {
        try {
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            int[] selectedColumns = table.getSelectedColumns();
            int[] selectedRows = table.getSelectedRows();
            int columnCount = selectedColumns.length;
            for (int y = 0; y < selectedRows.length; y++) {
                int rowIndex = selectedRows[y];
                for (int x = 0; x < columnCount; x++) {
                    int columnIndex = selectedColumns[x];
                    Object oldValue = table.getValueAt(rowIndex, columnIndex);
                    model.updateValueChanged(table,
                                             rowIndex,
                                             columnIndex,
                                             oldValue,
                                             null);
                    table.setValueAt(null, rowIndex, columnIndex);
                }
            }
        } catch (SQLException ex) {
            onError(ex);
        }
    }

    /**
     * j["VKs}"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuAddNewRowSelected(JTable table) {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        int rowCount = model.getRowCount();
        model.addRowAsInsert(new Object[model.getColumnCount()]);
        table.changeSelection(rowCount, 1, false, false);
    }

    /**
     * j["Rs[}"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuCopyInsertRowSelected(JTable table) {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        int[] selectedRows = table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; i++) {
            List row = (List)model.getDataVector().get(selectedRows[i]);
            model.addRowAsInsert(row.toArray());
            table.changeSelection(model.getRowCount(), 1, false, false);
        }
    }

    /**
     * j["Nbv{[h}"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuInsertClipboardDataelected(JTable table) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable t = clipboard.getContents(null);
            int columnCount = table.getColumnCount();
            Object value = t.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            Importer importer = new TabSeparatedTextImporter(String.valueOf(value));
            try {
                List errorList = new ArrayList();
                for (int rowIndex = table.getRowCount();; rowIndex++) {
                    Object[] row = importer.nextRow();
                    if (row.length == 0) {
                        break;
                    }
                    int size = Math.min(row.length, columnCount - 1);
                    Object[] insertData = new Object[size + 1];
                    System.arraycopy(row, 0, insertData, 1, size);
                    model.addRowAsInsert(insertData);
                    try {
                        model.updateRowInserted(table, rowIndex);
                    } catch (SQLException ex) {
                        log.warn("", ex);
                        errorList.add(ex);
                    }
                }
                if (!errorList.isEmpty()) {
                    String message = errorList.size() + " error(s) occurred";
                    DialogMessage.alert(table, message);
                }
            } finally {
                importer.close();
            }
        } catch (UnsupportedFlavorException ex) {
            onError(ex);
        } catch (IOException ex) {
            onError(ex);
        } catch (RuntimeException ex) {
            onError(ex);
        }
    }

    /**
     * j["}m"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuFixInsertSelected(JTable table) {
        try {
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            int[] selectedRows = table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; i++) {
                model.updateRowInserted(table, selectedRows[i]);
            }
        } catch (SQLException ex) {
            onError(ex);
        } catch (RuntimeException ex) {
            onError(ex);
        }
    }

    /**
     * j["s폜"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuDeleteRowSelected(JTable table) {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        int[] selectedRows = table.getSelectedRows();
        int selectedRowCount = selectedRows.length;
        if (selectedRowCount < 1) {
            return;
        }
        int selectedRow = selectedRows[0];
        for (int i = 0; i < selectedRowCount; i++) {
            boolean isSelectedInsertRow = model.isInsertRow(selectedRow);
            if (!isSelectedInsertRow) {
                try {
                    model.updateRowDeleted(table, new int[]{selectedRow});
                } catch (SQLException ex) {
                    onError(ex);
                }
            }
            model.removeRow(selectedRow);
        }
    }

    /**
     * j["\[g"IꂽƂ̏B
     * @param table e[u
     * @param columnIndex I
     */
    void onMenuSortColumnSelected(JTable table, int columnIndex) {
        if (columnIndex >= 0) {
            ResultSetTable t = (ResultSetTable)table;
            t.requestSort(columnIndex);
        }
    }

    /**
     * j["I"IꂽƂ̏B
     * @param table e[u
     * @param columnIndex I
     */
    void onMenuSelectColumnSelected(JTable table, int columnIndex) {
        if (columnIndex >= 0) {
            ResultSetTable t = (ResultSetTable)table;
            t.selectColumn(columnIndex, columnIndex);
        }
    }

    /**
     * G[̏B
     * @param th O
     */
    void onError(Throwable th) {
        log.error("", th);
        DialogMessage.alert(parent, th.getMessage());
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("menu.ContextMenu." + key);
    }

}