package net.argius.stew.command;

import java.io.*;
import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * f[^t@C荞ރR}hB
 *
 * t@C`́Agqɂ莩IɑIB
 * <ul>
 * <li>gq"csv"̏ꍇCSV`Ƃăt@CǂݍށB
 * <li>LȊȌꍇ̓^u؂`Ƃăt@CǂݍށB
 * </ul>
 * 
 * "Load"R}hƈقȂA"batch"gpB
 */
public final class Import extends Load {

    private static final Logger log = LoggerFactory.getLogger(Import.class);
    private static final String USAGE = getUsage("import");

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(USAGE);
        }
        // 
        int argsIndex = 2;
        String p1 = parameter.get(argsIndex++);
        String p2 = parameter.get(argsIndex++);
        String p3 = parameter.get(argsIndex++);
        boolean hasHeader = p3.equalsIgnoreCase("header");
        if (log.isDebugEnabled()) {
            log.debug("file : " + p1);
            log.debug("table : " + p2);
            log.debug("hasHeader : " + hasHeader);
        }
        try {
            // s
            loadRecord(conn, new File(p1), p2, hasHeader);
        } catch (IOException ex) {
            throw new CommandException(ex);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.command.Load#insertRecords(java.sql.PreparedStatement, net.argius.stew.io.Importer)
     */
    protected void insertRecords(PreparedStatement stmt, Importer importer) throws IOException, SQLException {
        int recordCount = 0;
        int insertedCount = 0;
        int errorCount = 0;
        while (true) {
            Object[] row = importer.nextRow();
            if (row.length == 0) {
                break;
            }
            ++recordCount;
            try {
                for (int i = 0; i < row.length; i++) {
                    stmt.setObject(i + 1, row[i]);
                }
                stmt.addBatch();
            } catch (SQLException ex) {
                String message = "error occurred at " + recordCount;
                if (log.isTraceEnabled()) {
                    log.trace(message, ex);
                } else if (log.isDebugEnabled()) {
                    log.debug(message + " : " + ex);
                }
                ++errorCount;
            }
        }
        int[] result = stmt.executeBatch();
        insertedCount = result.length;
        if (log.isDebugEnabled()) {
            List updateCountList = new ArrayList();
            for (int i = 0; i < result.length; i++) {
                updateCountList.add(Integer.toString(result[i]));
            }
            log.debug("updateCounts = " + updateCountList);
            log.debug("record   = " + recordCount);
            log.debug("inserted = " + insertedCount);
            log.debug("error    = " + errorCount);
        }
        Object[] arguments = {new Integer(insertedCount),
                              new Integer(recordCount)};
        outputMessage(".loaded", arguments);
    }

}