package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * DeleteR}hB
 */
public final class Delete extends Command {

    private static final Logger log = LoggerFactory.getLogger(Delete.class);

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        String sql = parameter.getAll();
        if (log.isDebugEnabled()) {
            log.debug("SQL : " + sql);
        }
        try {
            Statement stmt = conn.createStatement();
            try {
                setTimeout(stmt);
                int deletedCount = stmt.executeUpdate(sql);
                Object[] arguments = {new Integer(deletedCount)};
                outputMessage(".deleted", arguments);
            } finally {
                stmt.close();
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

}