package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * CountR}hB
 * Ɉv̂ݕ\Bʂ͕\ȂB
 */
public final class Count extends Command {

    private static final Logger log = LoggerFactory.getLogger(Count.class);
    private static final String USAGE = getUsage("count");

    /* (overridden)
     * @see net.argius.stew.Command#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        // 
        String input = parameter.getAll(2);
        String sql = "SELECT COUNT(*) FROM " + input;
        if (log.isDebugEnabled()) {
            log.debug("SQL : " + sql);
        }
        // s
        try {
            execute(conn, sql);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.Command#isReadOnly()
     */
    public boolean isReadOnly() {
        return true;
    }

    /**
     * SQLsB
     * @param conn RlNV
     * @param sql SQL
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void execute(Connection conn, String sql) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            setTimeout(stmt);
            ResultSet rs = stmt.executeQuery(sql);
            try {
                rs.next(); // K true ɂȂ͂
                Object[] arguments = {new Integer(rs.getInt(1))};
                outputMessage(".selected", arguments);
            } finally {
                rs.close();
            }
        } finally {
            stmt.close();
        }
    }

}