/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.argius.stew.LocalSystem;
import net.argius.stew.io.CsvFormatter;
import net.argius.stew.io.Exporter;

public final class SimpleExporter
extends Exporter {
    private static final String PROP_FORMAT = SimpleExporter.class.getName() + ".format";
    private final String separator;
    private final CsvFormatter formatter;
    private PrintWriter out;

    public SimpleExporter(OutputStream outputStream, String string) {
        super(outputStream);
        this.out = new PrintWriter(outputStream);
        this.separator = string;
        this.formatter = SimpleExporter.getCsvFormatter();
    }

    private static CsvFormatter getCsvFormatter() {
        String string = LocalSystem.getProperty(PROP_FORMAT);
        if (string.equalsIgnoreCase("RAW")) {
            return CsvFormatter.RAW;
        }
        if (string.equalsIgnoreCase("STRING")) {
            return CsvFormatter.STRING;
        }
        if (string.equalsIgnoreCase("ESCAPE")) {
            return CsvFormatter.ESCAPE;
        }
        return CsvFormatter.AUTO;
    }

    public void addRow(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (i > 0) {
                this.out.print(this.separator);
            }
            String string = object instanceof String ? (String)object : (objectArray[i] != null ? object.toString() : "");
            this.out.print(this.formatter.format(string));
        }
        this.out.println();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        finally {
            this.out = null;
            super.close();
        }
    }
}

