/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.argius.stew.io.ImporterFactory;
import net.argius.stew.io.Path;

public abstract class Importer {
    protected InputStream is;
    protected boolean wasReadHeader;

    protected Importer(InputStream inputStream) {
        this.is = inputStream;
        this.wasReadHeader = false;
    }

    public Object[] getHeader() throws IOException {
        Object[] objectArray = this.readHeader();
        this.wasReadHeader = true;
        return objectArray;
    }

    protected Object[] readHeader() throws IOException {
        return this.nextRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.is != null) {
            try {
                this.is.close();
            }
            finally {
                this.is = null;
            }
        }
    }

    public static Importer getImporter(File file) throws IOException {
        return ImporterFactory.createImporter(new Path(file));
    }

    public static Importer getImporter(String string) throws IOException {
        return ImporterFactory.createImporter(new Path(string));
    }

    public abstract Object[] nextRow() throws IOException;
}

