/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.Environment;
import net.argius.stew.OutputProcessor;
import net.argius.stew.Prompt;
import net.argius.stew.ResultSetReference;
import net.argius.stew.StringClass;
import net.argius.stew.gui.ConnectorMapEditDialog;
import net.argius.stew.gui.ConsoleTextArea;
import net.argius.stew.gui.ContextMenu;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.FontChooser;
import net.argius.stew.gui.FormedFont;
import net.argius.stew.gui.Menu;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.ResultSetTable;
import net.argius.stew.gui.Window;
import net.argius.stew.gui.WindowLauncher;

final class WindowOutputProcessor
implements OutputProcessor {
    private static final Logger log = LoggerFactory.getLogger(WindowOutputProcessor.class);
    Window window;
    JSplitPane splitPane;
    ResultSetTable resultSetTable;
    ConsoleTextArea consoleTextArea;
    JLabel statusBarLabel;
    private Environment env;
    private WindowLauncher launcher;
    private FontChooser fontChooser;
    private ThreadLocal currentCommand;

    WindowOutputProcessor(Environment environment, WindowLauncher windowLauncher) {
        try {
            this.env = environment;
            this.launcher = windowLauncher;
            this.fontChooser = new FontChooser();
            this.currentCommand = new ThreadLocal();
            environment.setOutputProcessor(this);
            this.initializeComponents();
            this.fontChooser.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = changeEvent.getSource();
                    if (object instanceof Font) {
                        WindowOutputProcessor.this.onFontChanged((Font)object);
                    }
                }
            });
            this.window.loadConfiguration();
            this.window.setVisible(true);
            this.output(new Prompt(environment));
            this.consoleTextArea.requestFocus();
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
            this.close();
        }
    }

    private void initializeComponents() {
        this.window = new Window(this.env, this);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WindowOutputProcessor.this.onWindowClosing();
            }
        });
        this.splitPane = new JSplitPane(0);
        this.resultSetTable = new ResultSetTable(this.env);
        this.resultSetTable.setAutoResizeMode(0);
        this.resultSetTable.setColumnSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane(this.resultSetTable);
        jScrollPane.setVisible(true);
        this.splitPane.setTopComponent(jScrollPane);
        this.consoleTextArea = new ConsoleTextArea(this);
        this.consoleTextArea.setMargin(new Insets(4, 8, 4, 4));
        this.consoleTextArea.addMouseListener(new ContextMenu(this.window));
        JScrollPane jScrollPane2 = new JScrollPane(this.consoleTextArea);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        this.splitPane.setBottomComponent(jScrollPane2);
        this.splitPane.setResizeWeight(0.3);
        this.splitPane.validate();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.statusBarLabel = new JLabel(" ");
        this.statusBarLabel.setVisible(false);
        jPanel.add((Component)this.statusBarLabel, "West");
        this.statusBarLabel.setFont(FormedFont.Small);
        this.statusBarLabel.setForeground(Color.BLUE);
        Menu menu = new Menu(this.env, this);
        this.window.setJMenuBar(menu);
        this.window.getContentPane().add((Component)this.splitPane, "Center");
        this.window.getContentPane().add((Component)jPanel, "Last");
    }

    public void output(Object object) {
        try {
            if (object instanceof ResultSetReference) {
                ResultSetReference resultSetReference = (ResultSetReference)object;
                this.outputResultSetReference(resultSetReference);
            } else if (object instanceof Prompt) {
                this.consoleTextArea.append(object.toString());
            } else {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println(object);
                this.consoleTextArea.append(stringWriter.toString());
            }
            this.consoleTextArea.validate();
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
    }

    public void close() {
        this.window.dispose();
        this.launcher.remove(this);
        this.env.release();
    }

    private void outputResultSetReference(ResultSetReference resultSetReference) {
        try {
            ColumnOrder columnOrder = resultSetReference.getOrder();
            String string = (String)this.currentCommand.get();
            int n = this.resultSetTable.outputResultSet(resultSetReference.getResultSet(), columnOrder, string);
            resultSetReference.setRecordCount(n);
        }
        catch (SQLException sQLException) {
            log.error("", sQLException);
            this.onError(sQLException);
        }
    }

    int getSequencialNumber() {
        return this.launcher.getSequentialNumber();
    }

    void requestCommand(String string) {
        this.requestCommand(string, "");
    }

    void requestCommand(String string, String string2) {
        final Environment environment = this.env;
        final ThreadLocal threadLocal = this.currentCommand;
        final String string3 = string;
        this.output(string2);
        this.window.setAllComponentsEnabled(false);
        Thread thread = new Thread(){

            public void run() {
                try {
                    threadLocal.set(string3);
                    double d = this.executeCommand(string3);
                    EventQueue.invokeLater(new Runnable(this, d){
                        private final /* synthetic */ double val$execTime;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$execTime = d;
                        }

                        public void run() {
                            3.access$000(this.this$1).window.setAllComponentsEnabled(true);
                            3.access$000(this.this$1).output(new Prompt(3.access$100(this.this$1)));
                            3.access$000(this.this$1).setStatusMessage(3.access$200(this.this$1), this.val$execTime);
                            3.access$000(this.this$1).consoleTextArea.requestFocus();
                        }
                    });
                }
                catch (Throwable throwable) {
                    WindowOutputProcessor.this.onError(throwable);
                    WindowOutputProcessor.this.window.setAllComponentsEnabled(true);
                }
            }

            private double executeCommand(String string) {
                long l = System.currentTimeMillis();
                boolean bl = Command.invoke(environment, string);
                if (!bl) {
                    WindowOutputProcessor.this.close();
                }
                return (double)(System.currentTimeMillis() - l) / 1000.0;
            }

            static /* synthetic */ WindowOutputProcessor access$000(3 var0) {
                return var0.WindowOutputProcessor.this;
            }

            static /* synthetic */ Environment access$100(3 var0) {
                return var0.environment;
            }

            static /* synthetic */ String access$200(3 var0) {
                return var0.string3;
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    void setStatusMessage(String string, double d) {
        String string2 = Messages.getString("window.StatusBar.format");
        Object[] objectArray = new Object[]{string, new Double(d)};
        String string3 = MessageFormat.format(string2, objectArray);
        this.statusBarLabel.setText(string3);
    }

    void gotoInput() {
        this.consoleTextArea.requestFocus();
    }

    void requestShowConnectorMapEditDialog() {
        ConnectorMapEditDialog connectorMapEditDialog = new ConnectorMapEditDialog(this.window, this.env);
        connectorMapEditDialog.pack();
        connectorMapEditDialog.setModal(true);
        connectorMapEditDialog.setLocationRelativeTo(this.window);
        connectorMapEditDialog.setVisible(true);
    }

    protected void finalize() throws Throwable {
        log.info("removing : " + this);
        super.finalize();
    }

    Font getFont() {
        return this.fontChooser.getCurrentFont();
    }

    void onFontChanged(Font font) {
        this.fontChooser.setCurrentFont(font);
        this.resultSetTable.setFont(font);
        this.consoleTextArea.setFont(font);
    }

    void createNew() {
        this.launcher.launch(new Environment(this.env));
    }

    void requestExit() {
        this.launcher.closeAll();
    }

    void requestShowFontChooser() {
        this.fontChooser.showDialog(this.window);
    }

    void onWindowClosing() {
        int n = this.launcher.getWindowCount();
        if (n <= 1) {
            Menu menu = (Menu)this.window.getJMenuBar();
            menu.onMenuQuitSelected();
        } else {
            String string;
            boolean bl;
            Connection connection = this.env.getCurrentConnection();
            try {
                bl = connection != null && !connection.isClosed();
            }
            catch (SQLException sQLException) {
                this.onError(sQLException);
                return;
            }
            if (bl && DialogMessage.confirmYesNo(this.window, string = Messages.getString("menu.Menu.message.closewindow")) != 0) {
                return;
            }
            this.close();
        }
    }

    void onError(Throwable throwable) {
        log.error("", throwable);
        String string = throwable.getMessage();
        if (StringClass.isEmpty(string)) {
            string = throwable.toString();
        }
        DialogMessage.alert(this.window, string);
    }
}

