/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;

public final class LocalSystem {
    private static final String FILE_PROPERTIES = "stew.properties";
    private static final Logger log = LoggerFactory.getLogger(LocalSystem.class);
    private static File directory = LocalSystem.initializeDirectory();
    private static Properties props = LocalSystem.initializeProperties();

    private LocalSystem() {
    }

    private static File initializeDirectory() {
        String string = System.getProperty("net.argius.stew.directory", System.getProperty("user.home"));
        File file = new File(string, ".stew");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static Properties initializeProperties() {
        Properties properties;
        try {
            properties = LocalSystem.getFileProperties();
        }
        catch (IOException iOException) {
            log.warn("", iOException);
            properties = new Properties();
        }
        Properties properties2 = new Properties(properties);
        properties2.putAll((Map<?, ?>)System.getProperties());
        Properties properties3 = new Properties(properties2);
        if (log.isTraceEnabled()) {
            Properties[] propertiesArray = new Properties[]{properties3, properties2, properties};
            for (int i = 0; i < propertiesArray.length; ++i) {
                Properties properties4 = propertiesArray[i];
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                properties4.list(printWriter);
                log.trace(stringWriter);
            }
        }
        return properties3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFileProperties() throws IOException {
        InputStream inputStream;
        Object object;
        Properties properties = new Properties();
        String string = System.getProperty("net.argius.stew.properties");
        if (string != null) {
            object = new File(string);
            if (((File)object).isDirectory()) {
                object = new File((File)object, FILE_PROPERTIES);
            }
            if (((File)object).exists()) {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                try {
                    properties.load(fileInputStream);
                    Properties properties2 = properties;
                    return properties2;
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        if ((inputStream = LocalSystem.class.getResourceAsStream((String)(object = "/stew.properties"))) != null) {
            properties.load(inputStream);
            return properties;
        }
        File file = new File(directory, FILE_PROPERTIES);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Properties properties3 = properties;
                return properties3;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return properties;
    }

    public static File getDirectory() {
        return directory;
    }

    public static String getProperty(String string) {
        String string2 = props.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static Object setProperty(String string, String string2) {
        return props.setProperty(string, string2);
    }

    public static boolean containsKey(String string) {
        return props.getProperty(string) != null;
    }
}

