/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.argius.stew.Connector;
import net.argius.stew.Password;

public final class ConnectorMap
extends AbstractMap {
    private final Map map;

    public ConnectorMap() {
        this.map = new LinkedHashMap();
    }

    public ConnectorMap(List list, Properties properties) {
        this.map = new LinkedHashMap();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            Properties properties2 = new Properties();
            this.copyPropertyById(string, "name", properties, properties2);
            this.copyPropertyById(string, "driver", properties, properties2);
            this.copyPropertyById(string, "classpath", properties, properties2);
            this.copyPropertyById(string, "url", properties, properties2);
            this.copyPropertyById(string, "user", properties, properties2);
            this.copyPropertyById(string, "password", properties, properties2);
            this.copyPropertyById(string, "password.class", properties, properties2);
            this.copyPropertyById(string, "readonly", properties, properties2);
            Connector connector = new Connector(string, properties2);
            this.map.put(string, connector);
        }
    }

    public ConnectorMap(ConnectorMap connectorMap) {
        this.map = new LinkedHashMap(connectorMap.map);
    }

    private void copyPropertyById(String string, String string2, Properties properties, Properties properties2) {
        String string3 = string + '.' + string2;
        String string4 = properties.getProperty(string3, "");
        properties2.setProperty(string2, string4);
    }

    public Connector getConnector(String string) {
        return (Connector)this.get(string);
    }

    public void setConnector(String string, Connector connector) {
        this.put(string, connector);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Object[] objectArray = this.map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            Connector connector = this.getConnector(string);
            Password password = connector.getPassword();
            properties.setProperty(string + ".name", connector.getName());
            properties.setProperty(string + ".driver", connector.getDriver());
            properties.setProperty(string + ".classpath", connector.getClasspath());
            properties.setProperty(string + ".url", connector.getUrl());
            properties.setProperty(string + ".user", connector.getUser());
            properties.setProperty(string + ".password", password.getTransformedString());
            properties.setProperty(string + ".password.class", password.getClass().getName());
            properties.setProperty(string + ".readonly", Boolean.toString(connector.isReadOnly()));
        }
        return properties;
    }

    public Object put(Object object, Object object2) {
        return this.map.put(object, object2);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }
}

