/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.ByteArrayOutputStream;
import javax.crypto.Cipher;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Password;
import net.argius.stew.StringClass;

public abstract class CipherPassword
implements Password {
    private static final Logger log = LoggerFactory.getLogger(CipherPassword.class);
    private static String secretKey = "";
    private String transformedString;

    public final String getTransformedString() {
        if (this.transformedString != null) {
            return this.transformedString;
        }
        return "";
    }

    public final void setTransformedString(String string) {
        if (string != null) {
            this.transformedString = string;
        }
    }

    public final String getRowString() {
        if (this.transformedString != null) {
            return this.decrypt(this.transformedString);
        }
        return "";
    }

    public final void setRowString(String string) {
        if (string != null) {
            this.transformedString = this.encrypt(string);
        }
    }

    public final boolean hasPassword() {
        return this.transformedString != null;
    }

    public static void setSecretKey(String string) {
        if (!StringClass.isEmpty(string)) {
            secretKey = string;
        }
    }

    private String encrypt(String string) {
        try {
            Cipher cipher = this.getCipherInstance(secretKey, 1);
            byte[] byArray = cipher.doFinal(string.getBytes());
            return CipherPassword.toHexString(byArray);
        }
        catch (Exception exception) {
            log.warn("", exception);
            return "";
        }
    }

    private String decrypt(String string) {
        try {
            Cipher cipher = this.getCipherInstance(secretKey, 2);
            byte[] byArray = cipher.doFinal(CipherPassword.toBytes(string));
            return new String(byArray);
        }
        catch (Exception exception) {
            log.warn("", exception);
            return "";
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(0 <= by && by < 16 ? "0" : "");
            stringBuffer.append(Integer.toHexString(by & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static byte[] toBytes(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            byteArrayOutputStream.write(Integer.parseInt(string2, 16));
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected abstract Cipher getCipherInstance(String var1, int var2);
}

