package net.argius.stew.io;

import java.io.*;
import java.util.*;
import java.util.regex.*;

/**
 * XML`̃C|[gB
 */
public final class XmlImporter extends Importer {

    private static final Pattern PATTERN_TAG = Pattern.compile("<(/?)([A-Za-z0-9]+)([^/>]+)?(/?) *>");
    private static final Pattern PATTERN_TAG_HEADER_ATTRIBUTE = Pattern.compile("index=\"[^0-9\"]*([0-9]+)[^0-9\"]*\"",
                                                                                Pattern.CASE_INSENSITIVE);
    private static final String SLASH = "/";
    private static final String TAG_TABLE = "table";
    private static final String TAG_HEADERROW = "headerrow";
    private static final String TAG_HEADER = "header";
    private static final String TAG_ROW = "row";
    private static final String TAG_NULL = "null";

    private BufferedReader reader;
    private CharSequenceFIFO buffer;
    private char[] chars;
    private boolean hasMoreData;

    /**
     * XmlImporter̐B
     * @param is ̓Xg[
     * @throws IOException XMLp[T̏Ɏsꍇ 
     */
    public XmlImporter(InputStream is) throws IOException {
        super(is);
        String enc = getEncoding();
        this.reader = new BufferedReader(new InputStreamReader(is, enc));
        this.buffer = new CharSequenceFIFO();
        this.chars = new char[1024];
        this.hasMoreData = seekStartTag(TAG_TABLE);
    }

    /**
     * CDATAZNVꍇɓWJB
     * @param o IuWFNg
     * @return σIuWFNg
     */
    private static Object parseCData(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            if (s.matches("^<!\\[CDATA\\[.*\\]\\]>$")) {
                String value = s.substring(9, s.length() - 3);
                if (value.indexOf("]]&gt;") >= 0) {
                    value = value.replaceAll("\\]\\]&gt;", "]]>");
                }
                return value;
            }
        }
        return o;
    }

    /* (overridden)
     * @see net.argius.stew.io.Importer#readHeader()
     */
    protected Object[] readHeader() throws IOException {
        Map map = new HashMap();
        boolean isHeaderRow = false;
        while (true) {
            Matcher m = PATTERN_TAG.matcher(buffer);
            if (m.find()) {
                String g1 = m.group(1);
                String name = m.group(2);
                String attribute = String.valueOf(m.group(3));
                String g4 = m.group(4);
                buffer.draw(m.end());
                if (name.equalsIgnoreCase(TAG_HEADERROW)) {
                    if (g1.equals(SLASH) || g4.equals(SLASH)) {
                        isHeaderRow = false;
                        break;
                    } else {
                        isHeaderRow = true;
                        continue;
                    }
                } else if (name.equalsIgnoreCase(TAG_TABLE)
                           || name.equalsIgnoreCase(TAG_ROW)) {
                    break;
                } else if (isHeaderRow && name.equalsIgnoreCase(TAG_HEADER)) {
                    Matcher mAttr = PATTERN_TAG_HEADER_ATTRIBUTE.matcher(attribute);
                    String index;
                    if (mAttr.find()) {
                        index = mAttr.group(1);
                    } else {
                        index = String.valueOf(map.size());
                    }
                    while (true) {
                        Matcher mEnd = PATTERN_TAG.matcher(buffer);
                        if (mEnd.find() && mEnd.group(1).equals(SLASH)) {
                            int iEnd = mEnd.start();
                            Object value = buffer.subSequence(0, iEnd);
                            map.put(index, parseCData(value));
                            buffer.draw(mEnd.end());
                            break;
                        }
                        if (readChars() <= 0) {
                            break;
                        }
                    }
                }
            } else {
                if (readChars() <= 0) {
                    break;
                }
            }
        }
        int max = 0;
        for (Iterator it = map.keySet().iterator(); it.hasNext();) {
            int intValue = Integer.parseInt((String)it.next());
            max = Math.max(max, intValue);
        }
        Object[] headers = new Object[max + 1];
        for (int i = 0; i <= max; i++) {
            String key = String.valueOf(i);
            if (map.containsKey(key)) {
                headers[i] = map.get(key);
            }
        }
        return headers;
    }

    /* (overridden)
     * @see net.argius.stew.io.Importer#close()
     */
    public void close() throws IOException {
        try {
            if (reader != null) {
                reader.close();
            }
        } finally {
            reader = null;
            buffer = null;
            chars = null;
            super.close();
        }
    }

    /* (overridden)
     * @see net.argius.stew.io.Importer#nextRow()
     */
    public Object[] nextRow() throws IOException {
        while (hasMoreData) {
            Matcher m = PATTERN_TAG.matcher(buffer);
            if (m.find()) {
                String name = m.group(2);
                String g4 = m.group(4);
                buffer.draw(m.end());
                if (name.equalsIgnoreCase(TAG_ROW)) {
                    if (g4.equals(SLASH)) {
                        return new Object[0];
                    } else {
                        return parseRow();
                    }
                } else if (name.equalsIgnoreCase(TAG_TABLE)) {
                    hasMoreData = false;
                }
            } else {
                if (readChars() <= 0) {
                    hasMoreData = false;
                    break;
                }
            }
        }
        return new Object[0];
    }

    /**
     * wb_GR[fBO擾B
     * @return GR[fBO
     * @throws IOException o̓G[ꍇ
     */
    private String getEncoding() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int c; (c = is.read()) >= 0;) {
            bos.write(c);
            if (c == '>') {
                break;
            }
        }
        String header = new String(bos.toByteArray(), "ISO8859-1");
        Pattern p = Pattern.compile("<\\?xml.+encoding=\"([^\"]+)\"\\?>",
                                    Pattern.CASE_INSENSITIVE);
        Matcher m = p.matcher(header);
        if (m.find()) {
            return m.group(1);
        } else {
            return "utf-8";
        }
    }

    /**
     * Jn^O܂͋vf^OTB
     * obt@̐擪́AJn^Ȍꍇ̓^ȌIʒuɁA
     * vf^Ȍꍇ̓^O̊JnʒuɁAꂼړB
     * ^OȂꍇ̓J[\ʒuύXȂB
     * @param tagName ^O
     * @return ^OȂ<code>true</code>AłȂ<code>false</code>
     * @throws IOException o̓G[ꍇ 
     */
    private boolean seekStartTag(String tagName) throws IOException {
        while (true) {
            Matcher m = PATTERN_TAG.matcher(buffer);
            if (m.find()) {
                String g1 = m.group(1);
                if (!g1.equals(SLASH)) {
                    if (tagName.equalsIgnoreCase(m.group(2))) {
                        int position;
                        if (m.group(4).equals(SLASH)) {
                            position = m.start();
                        } else {
                            position = m.end();
                        }
                        buffer.draw(position);
                        return true;
                    }
                }
            }
            if (readChars() <= 0) {
                break;
            }
        }
        return false;
    }

    /**
     * s͂B
     * @return ͂ꂽs̃f[^
     * @throws IOException o̓G[ꍇ 
     */
    private Object[] parseRow() throws IOException {
        List list = new ArrayList();
        while (hasMoreData) {
            Matcher m = PATTERN_TAG.matcher(buffer);
            if (m.find()) {
                String g1 = m.group(1);
                String name = m.group(2);
                String g4 = m.group(4);
                buffer.draw(m.end());
                if (g1.equals(SLASH)) {
                    if (name.equals(TAG_ROW)) {
                        return list.toArray();
                    } else if (name.equals(TAG_TABLE)) {
                        break;
                    }
                } else if (name.equalsIgnoreCase(TAG_NULL)) {
                    list.add(null);
                } else if (g4.equals(SLASH)) {
                    list.add(deserialize(name, ""));
                } else {
                    while (true) {
                        Matcher mEnd = PATTERN_TAG.matcher(buffer);
                        if (mEnd.find() && mEnd.group(1).equals(SLASH)) {
                            int iEnd = mEnd.start();
                            String value = buffer.subSequence(0, iEnd)
                                                 .toString();
                            list.add(deserialize(name, value));
                            buffer.draw(mEnd.end());
                            break;
                        }
                        if (readChars() <= 0) {
                            break;
                        }
                    }
                }
            } else {
                if (readChars() <= 0) {
                    break;
                }
            }
        }
        throw new IOException("</row> not found");
    }

    /**
     * IuWFNg𕜌B
     * @param name vf
     * @param value l
     * @return ꂽIuWFNg
     * @throws IOException o̓G[ꍇ
     */
    private static Object deserialize(String name, String value) throws IOException {
        return parseCData(StringBasedSerializer.deserialize(name, value));
    }

    /**
     * ʓǂݍށB
     * @return ǂݍ񂾕
     * @throws IOException o̓G[ꍇ
     */
    private int readChars() throws IOException {
        int length = reader.read(chars);
        if (length > 0) {
            buffer.add(chars, 0, length);
        }
        return length;
    }

}