package net.argius.stew.io;

import java.io.*;

/**
 * Importer̃t@NgB
 */
final class ImporterFactory {

    /**
     * ImporterFactory̐B
     */
    private ImporterFactory() {
        // empty
    }

    /**
     * Importer̐B
     * @param path pX
     * @return Importer
     * @throws IOException o̓G[ꍇ
     */
    static Importer createImporter(Path path) throws IOException {
        String suffix = path.getSuffix();
        if (suffix.equalsIgnoreCase("xml")) {
            return new XmlImporter(openFile(path));
        } else if (suffix.equalsIgnoreCase("csv")) {
            return new SmartImporter(openFile(path), ",");
        } else {
            return new SmartImporter(openFile(path), "\t");
        }
    }

    /**
     * t@CJB
     * @param file t@C
     * @return o̓Xg[
     * @throws IOException o̓G[ꍇ
     */
    private static InputStream openFile(File file) throws IOException {
        return new FileInputStream(file);
    }

}
