package net.argius.stew;

import java.sql.*;

import net.argius.stew.text.*;

/**
 * Wo͐B
 */
public class StandardOutputProcessor implements OutputProcessor {

    /* (overridden)
     * @see net.argius.stew.OutputProcessor#output(java.lang.Object)
     */
    public void output(Object object) {
        if (object instanceof ResultSetReference) {
            try {
                // ʃZbg
                ResultSetReference ref = (ResultSetReference)object;
                ResultSet rs = ref.getResultSet();
                ColumnOrder order = ref.getOrder();
                boolean needOrderChange = order.size() > 0;
                ResultSetMetaData rsmeta = rs.getMetaData();
                System.err.println();

                // 
                int columnCount;
                if (needOrderChange) {
                    columnCount = order.size();
                } else {
                    columnCount = rsmeta.getColumnCount();
                }
                int[] types = new int[columnCount];
                int[] sizes = new int[columnCount];
                StringBuffer border = new StringBuffer();
                for (int i = 0; i < columnCount; i++) {
                    int index;
                    if (needOrderChange) {
                        index = order.getOrder(i);
                    } else {
                        index = i + 1;
                    }
                    types[i] = rsmeta.getColumnType(index);
                    sizes[i] = rsmeta.getColumnDisplaySize(index);
                    String name = rsmeta.getColumnName(index);
                    System.err.print(Trimmer.trim(name, sizes[i]));
                    border.append(Trimmer.pad("", sizes[i], '-'));
                    if (i + 1 < columnCount) {
                        System.err.print(' ');
                        border.append(' ');
                    }
                }
                System.err.println();
                System.err.println(border);

                // [vJn
                int count = 0;
                while (rs.next()) {
                    ++count;
                    for (int i = 0; i < columnCount; i++) {
                        int index;
                        if (needOrderChange) {
                            index = order.getOrder(i);
                        } else {
                            index = i + 1;
                        }
                        String value = rs.getString(index);
                        System.out.print(Trimmer.trim(value, sizes[i]));
                        if (i + 1 < columnCount) {
                            System.out.print(' ');
                        }
                    }
                    System.out.println();
                }
                // [vI

                System.err.println();
                ref.setRecordCount(count);
            } catch (SQLException ex) {
                ex.printStackTrace(System.err);
            }
        } else if (object instanceof Prompt) {
            System.err.print(object);
        } else {
            System.err.println(object);
        }
        System.out.flush();
        System.err.flush();
    }

    /* (overridden)
     * @see net.argius.stew.OutputProcessor#close()
     */
    public void close() {
        // empty
    }

}