package net.argius.stew;

import java.io.*;

import net.argius.logging.*;
import net.argius.version.*;

/**
 * W͂LauncherB
 */
public final class StandardInputLauncher implements Launcher {

    private static final Logger log = LoggerFactory.getLogger(StandardInputLauncher.class);

    /* (overridden)
     * @see net.argius.stew.Launcher#launch(net.argius.stew.Environment)
     */
    public void launch(Environment env) {
        if (log.isInfoEnabled()) {
            log.info("start");
        }
        OutputProcessor out = env.getOutputProcessor();
        out.output(Constants.PRODUCT_DETAIL_NAME);
        out.output("version " + Version.getInstance(Launcher.class));
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            Prompt prompt = new Prompt(env);
            while (true) {
                out.output(prompt);
                String line = reader.readLine();
                if (log.isDebugEnabled()) {
                    log.debug("input : " + line);
                }
                if (line == null) {
                    break;
                }
                boolean isContinue = Command.invoke(env, line);
                if (!isContinue) {
                    break;
                }
            }
        } catch (IOException ex) {
            log.error("", ex);
            out.output(ex);
        }
        if (log.isInfoEnabled()) {
            log.info("end");
        }
    }

}