package net.argius.stew;

import java.io.*;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Map.*;

import net.argius.version.*;

/**
 * ڑݒGfB^(CUI)B
 */
public final class ConnectorMapEditor {

    private static final String MESSAGE_CONNECTOR_MAP_EDITOR = "message.ConnectorMapEditor.";

    private static final String[] PROP_KEYS = {"name", "classpath", "driver",
                                               "url", "user", "password",
                                               "readonly"};

    private final ConnectorMap map;

    private ConnectorMap previous;

    /**
     * ConnectorMapEditor̐B
     * @throws IOException o̓G[ꍇ 
     */
    private ConnectorMapEditor() throws IOException {
        this.previous = ConnectorConfiguration.load();
        this.map = new ConnectorMap(this.previous);
    }

    /**
     * bZ[W̎擾B
     * @param messageId bZ[WID
     * @return bZ[W
     */
    private static String getMessage(String messageId) {
        if (messageId.length() == 0) {
            throw new IllegalArgumentException("id is empty string");
        }
        return Messages.getString(MESSAGE_CONNECTOR_MAP_EDITOR + messageId);
    }

    /**
     * W͂̓͂𕶎ƂĎ擾B
     * @param messageId bZ[WID(bZ[Ww肵Ȃꍇ͋󕶎)
     * @return ͂ꂽ
     */
    private static String getInput(String messageId) {
        if (messageId.length() > 0) {
            print(getMessage(messageId));
        }
        print(" > ");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        } catch (IOException ex) {
            UnexpectedError error = new UnexpectedError();
            error.initCause(ex);
            throw error;
        }
    }

    /**
     * W͂̓͂p[^ƂĎ擾B
     * @param messageId bZ[WID(bZ[Ww肵Ȃꍇ͋󕶎)
     * @return ͂ꂽp[^
     */
    private static Parameter getParameter(String messageId) {
        String input = getInput(messageId);
        return new Parameter((input == null) ? "" : input);
    }

    /**
     * mFʂԂB
     * @param messageId bZ[WID(bZ[Ww肵Ȃꍇ͋󕶎)
     * @return <code>y</code>(Yes)̏ꍇ <code>true</code>A
     *         łȂ <code>false</code>
     */
    private static boolean confirmYes(String messageId) {
        if (messageId.length() > 0) {
            print(getMessage(messageId));
        }
        print("(y/N) > ");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return String.valueOf(reader.readLine()).equalsIgnoreCase("y");
        } catch (IOException ex) {
            UnexpectedError error = new UnexpectedError();
            error.initCause(ex);
            throw error;
        }
    }

    /**
     * Wo͂ɉsȂŏo͂B
     * @param o IuWFNg
     */
    private static void print(Object o) {
        System.out.print(o);
    }

    /**
     * Wo͂ɉŝݏo͂B
     */
    private static void printLine() {
        System.out.println();
    }

    /**
     * Wo͂ɉsŏo͂B
     * @param o IuWFNg
     */
    private static void printLine(Object o) {
        System.out.println(o);
    }

    /**
     * bZ[Wo͂B
     * @param messageId bZ[WID
     * @param argument MessageFormatɓn
     */
    private static void printMessage(String messageId) {
        printMessage(messageId, new Object[]{});
    }

    /**
     * bZ[Wo͂B
     * @param messageId bZ[WID
     * @param argument MessageFormatɓn
     */
    private static void printMessage(String messageId, Object argument) {
        printMessage(messageId, new Object[]{argument});
    }

    /**
     * bZ[Wo͂B
     * @param messageId bZ[WID
     * @param arguments MessageFormatɓn
     */
    private static void printMessage(String messageId, Object[] arguments) {
        String message;
        if (arguments.length > 0) {
            message = MessageFormat.format(getMessage(messageId), arguments);
        } else {
            message = getMessage(messageId);
        }
        printLine(message);
    }

    /**
     * RlN^}bveǂB
     * @param m1 RlN^}bv1
     * @param m2 RlN^}bv2
     * @return eȂ <code>true</code>AłȂ <code>false</code>
     */
    private static boolean isSameContent(ConnectorMap m1, ConnectorMap m2) {
        Set set = m1.keySet();
        if (!set.equals(m2.keySet())) {
            return false;
        }
        for (Iterator it = set.iterator(); it.hasNext();) {
            String id = (String)it.next();
            final Connector c1 = m1.getConnector(id);
            final Connector c2 = m2.getConnector(id);
            if (!c2.getProperties().equals(c1.getProperties())) {
                return false;
            }
        }
        return true;
    }

    /**
     * wv\B
     */
    private void printHelp() {
        printMessage("help.header");
        printLine("     help     : " + getMessage("help.help"));
        printLine("     a    id  : " + getMessage("help.add"));
        printLine("     m    id  : " + getMessage("help.modify"));
        printLine("     r    id  : " + getMessage("help.remove"));
        printLine("     copy A B : " + getMessage("help.copy"));
        printLine("     disp [id]: " + getMessage("help.disp"));
        printLine("     save     : " + getMessage("help.save"));
        printLine("     load     : " + getMessage("help.load"));
        printLine("     exit     : " + getMessage("help.exit"));
    }

    /**
     * ݒ̏ڍד͂B
     * @param id ύXRlN^ID
     * @param connector RlN^
     * @return ύXꍇ <code>true</code>AłȂ <code>false</code>
     */
    private boolean proceedInputProperties(String id, Connector connector) {
        Properties props = connector.getProperties();
        while (true) {
            printMessage("property.start1");
            printMessage("property.start2");
            for (int i = 0; i < PROP_KEYS.length; i++) {
                String key = PROP_KEYS[i];
                String value = props.getProperty(key);
                print(MessageFormat.format(getMessage("property.input"),
                                           new Object[]{key, value}));
                String input = getInput("");
                if (!StringClass.isEmpty(input)) {
                    props.setProperty(key, input);
                }
            }
            for (int i = 0; i < PROP_KEYS.length; i++) {
                String key = PROP_KEYS[i];
                System.err.println(key + "=" + props.getProperty(key));
            }
            if (confirmYes("property.tryconnect.confirm")) {
                try {
                    connector.getConnection();
                    printMessage("property.tryconnect.succeeded");
                } catch (SQLException ex) {
                    printMessage("property.tryconnect.failed", ex.getMessage());
                }
            }
            if (confirmYes("property.update.confirm")) {
                return true;
            }
            if (!confirmYes("property.retry.confirm")) {
                printMessage("property.update.cancel");
                return false;
            }
        }
    }

    /**
     * ǉB
     * @param id ǉRlN^ID
     */
    private void proceedAdd(String id) {
        if (map.containsKey(id)) {
            printMessage("proc.alreadyexists", id);
            return;
        }
        Properties props = new Properties();
        // ftHgl
        for (int i = 0; i < PROP_KEYS.length; i++) {
            props.setProperty(PROP_KEYS[i], "");
        }
        Connector connector = new Connector(id, props);
        if (proceedInputProperties(id, connector)) {
            map.put(id, connector);
            printMessage("proc.added", id);
        }
    }

    /**
     * ύXB
     * @param id ύXRlN^ID
     */
    private void proceedModify(String id) {
        if (!map.containsKey(id)) {
            printMessage("proc.notexists", id);
            return;
        }
        Connector connector = new Connector(id, map.getConnector(id));
        if (proceedInputProperties(id, connector)) {
            map.put(id, connector);
            printMessage("proc.modified", id);
        }
    }

    /**
     * 폜B
     * @param id 폜RlN^ID
     */
    private void proceedRemove(String id) {
        Connector connector = map.getConnector(id);
        printLine("ID[" + id + "]:" + connector.getName());
        if (confirmYes("proc.remove.confirm")) {
            map.remove(id);
            printMessage("proc.remove.finished");
        } else {
            printMessage("proc.remove.canceled");
        }
        printLine(map);
    }

    /**
     * Rs[B
     * @param src Rs[
     * @param dst Rs[
     */
    private void proceedCopy(String src, String dst) {
        if (!map.containsKey(src)) {
            printMessage("proc.notexists", src);
            printMessage("proc.copy.canceled");
            return;
        }
        if (map.containsKey(dst)) {
            printMessage("proc.alreadyexists", dst);
            printMessage("proc.copy.canceled");
            return;
        }
        map.put(dst, new Connector(dst, map.getConnector(src)));
        printMessage("proc.copy.finished");
    }

    /**
     * ݂IDꗗ\B
     */
    private void proceedDisplayIds() {
        for (Iterator it = map.entrySet().iterator(); it.hasNext();) {
            Entry entry = (Entry)it.next();
            String id = (String)entry.getKey();
            String indent = (id.length() < 10)
                    ? "          ".substring(id.length())
                    : "";
            printLine(indent + id + " : " + map.getConnector(id).getName());
        }
    }

    /**
     * w肳ꂽID̏ڍׂ\B
     * @param id ID
     */
    private void proceedDisplayDetail(String id) {
        if (!map.containsKey(id)) {
            printMessage("proc.notexists", id);
            return;
        }
        Properties props = map.getConnector(id).getProperties();
        for (int i = 0; i < PROP_KEYS.length; i++) {
            String key = PROP_KEYS[i];
            String indent = "          ".substring(key.length());
            printLine(indent + key + " : " + props.getProperty(key));
        }
    }

    /**
     * ݂̓et@CɕۑB
     * @throws IOException o̓G[ꍇ
     */
    private void proceedSave() throws IOException {
        if (map.equals(previous)) {
            printMessage("proc.nomodification");
        } else if (confirmYes("proc.save.confirm")) {
            ConnectorConfiguration.save(map);
            previous = new ConnectorMap(map);
            printMessage("proc.save.finished");
        } else {
            printMessage("proc.save.canceled");
        }
    }

    /**
     * t@C݂̓eɓǂݍށB
     * ݒ蒆̓e͔jimFjB
     * @throws IOException o̓G[ꍇ
     */
    private void proceedLoad() throws IOException {
        ConnectorMap m = ConnectorConfiguration.load();
        if (isSameContent(m, previous) && isSameContent(m, map)) {
            printMessage("proc.nomodification");
            return;
        }
        printMessage("proc.load.confirm1");
        if (confirmYes("proc.load.confirm2")) {
            printMessage("proc.load.finished");
        } else {
            printMessage("proc.load.canceled");
        }
    }

    /**
     * GfB^JnB
     * @param args (gp)
     */
    public static void main(String[] args) {
        printLine(Constants.PRODUCT_DETAIL_NAME);
        printLine("version " + Version.getInstance(Launcher.class));
        printLine();
        printMessage("main.start");
        printLine();
        try {
            ConnectorMapEditor editor = new ConnectorMapEditor();
            while (true) {
                Parameter p = getParameter("main.wait");
                String command = p.get(1);
                String id = p.get(2);
                if (command.equalsIgnoreCase("help")) {
                    editor.printHelp();
                } else if (command.equalsIgnoreCase("a")) {
                    editor.proceedAdd(id);
                } else if (command.equalsIgnoreCase("m")) {
                    editor.proceedModify(id);
                } else if (command.equalsIgnoreCase("r")) {
                    editor.proceedRemove(id);
                } else if (command.equalsIgnoreCase("copy")) {
                    editor.proceedCopy(id, p.get(3));
                } else if (command.equalsIgnoreCase("disp")) {
                    if (StringClass.isEmpty(id)) {
                        editor.proceedDisplayIds();
                    } else {
                        editor.proceedDisplayDetail(id);
                    }
                } else if (command.equalsIgnoreCase("save")) {
                    editor.proceedSave();
                } else if (command.equalsIgnoreCase("load")) {
                    editor.proceedLoad();
                } else if (command.equalsIgnoreCase("exit")) {
                    break;
                }
                printLine();
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }
        printLine();
        printMessage("main.end");
    }

}
