package net.argius.stew;

import java.io.*;
import java.util.*;
import java.util.regex.*;

/**
 * RlN^ݒB
 */
public final class ConnectorConfiguration {

    // IDp^[ : namevpeB擾
    private static final Pattern idPattern = Pattern.compile("^([^\\.]+)\\.name *=");

    /**
     * RlN^ݒǂݍށB
     * @return RlN^ݒ}bv
     * @throws IOException o̓G[ꍇ
     */
    public static ConnectorMap load() throws IOException {
        InputStream is = new FileInputStream(getPath());
        try {
            return load(is);
        } finally {
            is.close();
        }
    }

    /**
     * RlN^ݒǂݍށB
     * @param is ̓Xg[
     * @return RlN^ݒ}bv
     * @throws IOException o̓G[ꍇ
     */
    public static ConnectorMap load(InputStream is) throws IOException {
        // ēxgp邽߃LbV
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        for (int c; (c = is.read(buffer)) >= 0;) {
            bos.write(buffer, 0, c);
        }
        bos.flush();
        // IDXg쐬
        List idList = new ArrayList();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(bis));
        try {
            for (String line; (line = reader.readLine()) != null;) {
                Matcher matcher = idPattern.matcher(line);
                if (matcher.find()) {
                    idList.add(matcher.group(1));
                }
            }
        } finally {
            reader.close();
        }
        // vpeBƂēǂݍ
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(bos.toByteArray()));
        // 
        return new ConnectorMap(idList, props);
    }

    /**
     * RlN^ݒۑB
     * @param map RlN^ݒ}bv
     * @throws IOException o̓G[ꍇ
     */
    public static void save(ConnectorMap map) throws IOException {
        OutputStream os = new FileOutputStream(getPath());
        try {
            save(os, map);
        } finally {
            os.close();
        }
    }

    /**
     * RlN^ݒۑB
     * @param os o̓Xg[
     * @param map RlN^ݒ}bv
     * @throws IOException o̓G[ꍇ
     */
    public static void save(OutputStream os, ConnectorMap map) throws IOException {
        // storeňxi[
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        map.toProperties().store(bos, "");
        // 1s1vfƂListɋlߑւ
        List list = new ArrayList();
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bos.toByteArray())));
        try {
            for (String line; (line = r.readLine()) != null;) {
                if (!line.trim().startsWith("#")) {
                    list.add(line);
                }
            }
        } finally {
            r.close();
        }
        // IDɏo
        Comparator c = new ConnectorPropertyComparator(new ArrayList(map.keySet()));
        Collections.sort(list, c);
        PrintWriter out = new PrintWriter(os);
        try {
            for (int i = 0, n = list.size(); i < n; i++) {
                out.println(list.get(i));
            }
        } finally {
            out.flush();
        }
    }

    /**
     * pX̎擾B
     * @return pX
     */
    private static File getPath() {
        return new File(LocalSystem.getDirectory(), "connector.properties");
    }

    /**
     * ڑvpeB̏tsr֐B
     */
    private static final class ConnectorPropertyComparator implements
                                                    Comparator,
                                                    Serializable {

        /**
         * <code>serialVersionUID</code>
         */
        private static final long serialVersionUID = 1803584843826843857L;

        private final List idList;

        ConnectorPropertyComparator(List idList) {
            this.idList = idList;
        }

        /* (overridden)
         * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
         */
        public int compare(Object o1, Object o2) {
            // StringƂ
            String s1 = (String)o1;
            String s2 = (String)o2;
            int index1 = getIdIndex(s1);
            int index2 = getIdIndex(s2);
            if (index1 == index2) {
                return s1.compareTo(s2);
            } else {
                return index1 - index2;
            }
        }

        /**
         * ID̃CfbNX擾B
         * @param s vpeB1s̕
         * @return CfbNX
         */
        private int getIdIndex(String s) {
            String[] sa = s.split("\\.", 2);
            if (sa.length >= 2) {
                String id = sa[0];
                return idList.indexOf(id);
            }
            return -1;
        }

    }

}