package net.argius.stew.command;

import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * e[uR}hB
 * 
 * @see DatabaseMetaData#getTables(String, String, String, String[])
 */
public final class Find extends Command {

    private static final Logger log = LoggerFactory.getLogger(Find.class);
    private static final String USAGE = getUsage("find");

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        int argsIndex = 2;
        if (parameter.isEmpty(argsIndex)) {
            throw new UsageException(USAGE);
        }
        // 
        String p1 = parameter.get(argsIndex++);
        String p2 = parameter.get(argsIndex++);
        String p3 = parameter.get(argsIndex++);
        String p4 = parameter.get(argsIndex++);
        String p5 = parameter.get(argsIndex++);
        try {
            DatabaseMetaData dbmeta = conn.getMetaData();
            String tableNamePattern = editNamePattern(p1);
            String[] tableTypes = editTableType(p2);
            String schemaNamePattern = editNamePattern(p3);
            String catalogNamePattern = editNamePattern(p4);
            boolean isFull = p5.equalsIgnoreCase("FULL");
            if (log.isDebugEnabled()) {
                log.debug("name   : " + tableNamePattern);
                log.debug("types  : "
                          + (tableTypes == null
                                  ? null
                                  : Arrays.asList(tableTypes)));
                log.debug("schema : " + schemaNamePattern);
                log.debug("catalog: " + catalogNamePattern);
                log.debug("full?  : " + isFull);
            }
            // s
            ResultSet rs = dbmeta.getTables(catalogNamePattern,
                                            schemaNamePattern,
                                            tableNamePattern,
                                            tableTypes);
            try {
                ResultSetReference ref = new ResultSetReference(rs);
                if (!isFull) {
                    ColumnOrder order = ref.getOrder();
                    order.addOrder(3, getColumnName("name"));
                    order.addOrder(4, getColumnName("type"));
                    order.addOrder(1, getColumnName("schema"));
                    order.addOrder(2, getColumnName("catalog"));
                }
                output(ref);
                Object[] arguments = {new Integer(ref.getRecordCount())};
                outputMessage(".selected", arguments);
            } finally {
                rs.close();
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.Command#isReadOnly()
     */
    public boolean isReadOnly() {
        return true;
    }

    /**
     * 񖼂̎擾B
     * @param key L[[h
     * @return 
     */
    private String getColumnName(String key) {
        return Messages.getString("command.find.label." + key);
    }

    /**
     * e[u^Cv̕ҏWB
     * @param pattern e[u^Cv̎wp^[
     * @return e[u^Cv̔z
     */
    private String[] editTableType(String pattern) {
        if (StringClass.isBlank(pattern) || pattern.equals("*")) {
            return null;
        }
        return pattern.toUpperCase().split(",");
    }

    /**
     * ̃p^[̕ҏWB
     * @param pattern p^[
     * @return ҏWꂽ̃p^[
     * @throws SQLException SQL֘AG[ꍇ
     */
    private String editNamePattern(String pattern) throws SQLException {
        if (StringClass.isBlank(pattern)) {
            return null;
        } else if (pattern.equals("''") || pattern.equals("\"\"")) {
            return StringClass.EMPTY;
        }
        String edited = convertPattern(pattern);
        if (log.isDebugEnabled()) {
            log.debug("table-name-condition : " + edited);
        }
        return edited;
    }

}