package net.argius.stew.command;

import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * BindR}hB
 * oChJjY(PreparedStatement)gpSQLsB
 */
public final class Bind extends Command {

    private static final Logger log = LoggerFactory.getLogger(Bind.class);
    private static final String USAGE = getUsage("bind");
    private static final char SEPARATOR_CHAR = ':';

    /* (overridden)
     * @see net.argius.stew.Command#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        // 
        String input = parameter.getAll(2);
        int index = input.indexOf(SEPARATOR_CHAR);
        String sql;
        String[] parameters;
        if (index >= 0) {
            String[] splitted = input.split(String.valueOf(SEPARATOR_CHAR), 2);
            sql = splitted[0];
            parameters = splitted[1].split(",");
        } else {
            sql = input;
            parameters = new String[0];
        }
        if (log.isDebugEnabled()) {
            log.debug("SQL : " + sql);
            log.debug("Parameter : " + Arrays.asList(parameters));
        }
        // s
        try {
            execute(conn, sql, parameters);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /**
     * SQLsB
     * SELECT̏ꍇ <code>executeQuery()</code> \bhA
     * ȊȌꍇ <code>executeUpdate()</code> \bhgpB
     * @param conn RlNV
     * @param sql SQL
     * @param parameters p[^
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void execute(Connection conn, String sql, String[] parameters) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            setTimeout(stmt);
            for (int i = 0; i < parameters.length; i++) {
                stmt.setString(i + 1, parameters[i]);
            }
            if (isSelect(sql)) {
                ResultSet rs = stmt.executeQuery();
                try {
                    ResultSetReference ref = new ResultSetReference(rs);
                    output(ref);
                    Object[] arguments = {new Integer(ref.getRecordCount())};
                    outputMessage(".selected", arguments);
                } finally {
                    rs.close();
                }
            } else {
                int count = stmt.executeUpdate();
                Object[] arguments = {new Integer(count)};
                outputMessage(".proceeded", arguments);
            }
        } finally {
            stmt.close();
        }
    }

}