/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.HtmlExporter;
import net.argius.stew.io.Path;
import net.argius.stew.io.SimpleExporter;
import net.argius.stew.io.XmlExporter;

final class ExporterFactory {
    private ExporterFactory() {
    }

    static Exporter createExporter(Path path) throws IOException {
        String string = path.getSuffix();
        if (string.equalsIgnoreCase("xml")) {
            return new XmlExporter(ExporterFactory.openFile(path));
        }
        if (string.equalsIgnoreCase("htm") || string.equalsIgnoreCase("html")) {
            return new HtmlExporter(ExporterFactory.openFile(path), "");
        }
        if (string.equalsIgnoreCase("csv")) {
            return new SimpleExporter(ExporterFactory.openFile(path), ",");
        }
        return new SimpleExporter(ExporterFactory.openFile(path), "\t");
    }

    private static OutputStream openFile(File file) throws IOException {
        return new FileOutputStream(file);
    }
}

