/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Position;
import net.argius.stew.StringClass;
import net.argius.stew.gui.HistoryList;
import net.argius.stew.gui.WindowOutputProcessor;

final class ConsoleTextArea
extends JTextArea {
    private final WindowOutputProcessor op;
    private final HistoryList historyList;
    private int borderPosition;

    ConsoleTextArea(WindowOutputProcessor windowOutputProcessor) {
        this.op = windowOutputProcessor;
        this.historyList = new HistoryList();
        this.initializeView();
        this.initializeKeyBind();
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        abstractDocument.setDocumentFilter(new PrivateDocumentFilter(this));
        this.validate();
    }

    private void initializeView() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    private void initializeKeyBind() {
        InputMap inputMap = this.getInputMap();
        inputMap.put(this.getKeyStroke(10), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.sendCommand();
            }
        });
        inputMap.put(this.getKeyStroke(36), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.setCaretPosition(ConsoleTextArea.this.getBorderPosition());
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(67, 128), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConsoleTextArea.this.getSelectedText() == null) {
                    ConsoleTextArea.this.onBreak();
                } else {
                    DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
                    copyAction.actionPerformed(actionEvent);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(66, 512), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.onBreak();
            }
        });
    }

    void onBreak() {
        this.append(" [BREAK]> ");
        this.borderPosition = this.getCursorEndPosition();
        this.validate();
    }

    public void validate() {
        super.validate();
        int n = this.getCursorEndPosition();
        this.getCaret().setDot(n);
    }

    int getBorderPosition() {
        return this.borderPosition;
    }

    boolean isEditablePosition(int n) {
        return n >= this.borderPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCommand() {
        try {
            ConsoleTextArea consoleTextArea = this;
            synchronized (consoleTextArea) {
                Document document = this.getDocument();
                int n = this.getCaretPosition();
                int n2 = this.getCursorEndPosition();
                if (n != n2) {
                    this.setCaretPosition(n2);
                    return;
                }
                String string = document.getText(this.borderPosition, n2 - this.borderPosition);
                this.op.requestCommand(string);
                if (!StringClass.isBlank(string)) {
                    this.historyList.add(string);
                }
                this.borderPosition = this.getCursorEndPosition();
            }
        }
        catch (BadLocationException badLocationException) {
            this.op.onError(badLocationException);
        }
    }

    public void append(String string) {
        int n = string.length();
        super.append(string);
        this.borderPosition += n;
        this.setCaretPosition(this.getCursorEndPosition());
    }

    void replace(String string) {
        this.replaceRange(string, this.borderPosition, this.getCursorEndPosition());
    }

    void clear() {
        this.borderPosition = 0;
        this.setText("");
    }

    void turnBackHistory() {
        String string = this.historyList.getPrevious();
        if (!StringClass.isEmpty(string)) {
            this.replace(string);
        }
    }

    void turnNextHistory() {
        String string = this.historyList.getNext();
        if (!StringClass.isEmpty(string)) {
            this.replace(string);
        }
    }

    private KeyStroke getKeyStroke(int n) {
        return KeyStroke.getKeyStroke(n, 0);
    }

    private int getCursorEndPosition() {
        Document document = this.getDocument();
        Position position = document.getEndPosition();
        return position.getOffset() - 1;
    }

    private static final class PrivateDocumentFilter
    extends DocumentFilter {
        private final ConsoleTextArea consoleTextArea;

        PrivateDocumentFilter(ConsoleTextArea consoleTextArea) {
            this.consoleTextArea = consoleTextArea;
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.remove(filterBypass, n, n2);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }
    }
}

