package net.argius.stew.io;

import java.io.*;
import java.sql.*;
import java.util.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * o͌ʂGNX|[gɈϏo͐B
 */
public final class ExporterOutputProcessor implements OutputProcessor {

    private static final Logger log = LoggerFactory.getLogger(ExporterOutputProcessor.class);

    private final Exporter exporter;
    private final OutputProcessor output;
    private final boolean withHeader;

    /**
     * ExporterOutputProcessor̐B
     * @param exporter GNX|[g
     * @param output ʂ̏o͐
     * @param withHeader wb_L
     */
    public ExporterOutputProcessor(Exporter exporter,
                                   OutputProcessor output,
                                   boolean withHeader) {
        this.exporter = exporter;
        this.output = output;
        this.withHeader = withHeader;
    }

    /* (overridden)
     * @see net.argius.stew.OutputProcessor#output(java.lang.Object)
     */
    public void output(Object object) {
        try {
            if (object instanceof ResultSetReference) {
                ResultSetReference ref = (ResultSetReference)object;
                ColumnOrder order = ref.getOrder();
                int count = outputResultSet(ref.getResultSet(), order);
                ref.setRecordCount(count);
            } else {
                output.output(object);
            }
        } catch (IOException ex) {
            log.error("", ex);
            output.output(ex.getMessage());
        } catch (SQLException ex) {
            log.error("", ex);
            output.output(ex.getMessage());
        }
    }

    /**
     * ʃZbgo͂B
     * @param rs ʃZbg
     * @param order 
     * @return ʂ̌
     * @throws IOException o̓G[ꍇ
     * @throws SQLException SQL֘AG[ꍇ
     */
    private int outputResultSet(ResultSet rs, ColumnOrder order) throws IOException, SQLException {
        int count = 0;
        boolean needOrderChange = order.size() > 0;
        int columnCount;
        List header = new ArrayList();
        if (needOrderChange) {
            columnCount = order.size();
            for (int i = 0; i < columnCount; i++) {
                header.add(order.getName(i));
            }
        } else {
            ResultSetMetaData m = rs.getMetaData();
            columnCount = m.getColumnCount();
            for (int i = 0; i < columnCount; i++) {
                header.add(m.getColumnName(i + 1));
            }
        }
        if (withHeader) {
            exporter.addHeader(header.toArray());
        }
        while (rs.next()) {
            ++count;
            Object[] row = new Object[columnCount];
            for (int i = 0; i < columnCount; i++) {
                int index = (needOrderChange) ? order.getOrder(i) : i + 1;
                row[i] = rs.getObject(index);
            }
            exporter.addRow(row);
        }
        return count;
    }

    /* (overridden)
     * @see net.argius.stew.OutputProcessor#close()
     */
    public void close() {
        // empty
    }

}