package net.argius.stew;

/**
 * "NX"NXB
 */
public final class StringClass implements CharSequence {

    /**
     * 󕶎B
     */
    public static final String EMPTY = "";

    private char[] value;

    /**
     * StringClass̐B
     * @param value ̔z
     */
    public StringClass(char[] value) {
        this(value, 0, value.length);
    }

    /**
     * StringClass̐B
     * @param value ̔z
     * @param offset Jnʒu
     * @param length z̒
     */
    public StringClass(char[] value, int offset, int length) {
        this.value = new char[length];
        System.arraycopy(value, offset, this.value, 0, length);
    }

    /**
     * StringClass̐B
     * @param string 
     */
    public StringClass(String string) {
        char[] value;
        if (string == null) {
            value = new char[0];
        } else {
            value = string.toCharArray();
        }
        this.value = value;
    }


    /**
     * IuWFNgƂēǂ𒲍B
     * @param object1 IuWFNg1
     * @param object2 IuWFNg2
     * @return 12ƂēȂ<code>true</code>A
     *         łȂ<code>false</code>
     */
    public static boolean equals(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return object1 == object2;
        } else {
            String string1 = (object1 instanceof String)
                    ? (String)object1
                    : object1.toString();
            String string2 = (object2 instanceof String)
                    ? (String)object2
                    : object2.toString();
            return string1.equals(string2);
        }
    }

    /**
     * ̕񂪋󂩂ǂ𒲍B
     * @return ̕񂪋i<code>null</code> ܂ [jȂ<code>true</code>A
     *         łȂ<code>false</code>
     */
    public boolean isEmpty() {
        return value.length == 0;
    }

    /**
     * 񂪋󂩂ǂ𒲍B
     * @param string 
     * @return 񂪋i<code>null</code> ܂ [jȂ<code>true</code>A
     *         łȂ<code>false</code>
     */
    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    /**
     * ̕񂪋󔒂ǂ𒲍B
     * @return ̕񂪋󔒁i<code>null</code> ܂ trimĒ[jȂ<code>true</code>A
     *         łȂ<code>false</code>
     */
    public boolean isBlank() {
        return isBlank(toString());
    }

    /**
     * 񂪋󔒂ǂ𒲍B
     * @param string 
     * @return 񂪋󔒁i<code>null</code> ܂ trimĒ[jȂ<code>true</code>A
     *         łȂ<code>false</code>
     */
    public static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    /**
     * 擪啶̕ɕϊB
     * @return 擪啶̕ 
     */
    public String capitalize() {
        return capitalize(toString());
    }

    /**
     * 擪啶̕ɕϊB
     * @param string 
     * @return 擪啶̕ 
     */
    public static String capitalize(String string) {
        if (string == null) {
            return EMPTY;
        }
        StringBuffer buffer = new StringBuffer();
        if (string.length() > 0) {
            buffer.append(Character.toUpperCase(string.charAt(0)));
            buffer.append(string.substring(1).toLowerCase());
        }
        return buffer.toString();
    }

    /* (overridden)
     * @see java.lang.CharSequence#charAt(int)
     */
    public char charAt(int index) {
        return value[index];
    }
    
    /* (overridden)
     * @see java.lang.CharSequence#length()
     */
    public int length() {
        return value.length;
    }
    
    /* (overridden)
     * @see java.lang.CharSequence#subSequence(int, int)
     */
    public CharSequence subSequence(int start, int end) {
        return new StringClass(value, start, end - start);
    }
    
    /* (overridden)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        int result = 17;
        result = 37 * result + value.hashCode();
        return result;
    }
    
    /* (overridden)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        return equals(this, obj);
    }
    
    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new String(value);
    }

}